/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Notify2;
import org.polarion.team.svn.core.client.NotifyInformation;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.operation.local.IRemoteStatusOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IResourceChange;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class RemoteStatusOperation
extends AbstractWorkingCopyOperation
implements IRemoteStatusOperation,
Notify2 {
    protected Status[] statuses;
    protected Map pegRevisions = new HashMap();

    public RemoteStatusOperation(IResource[] resources) {
        super("Operation.UpdateStatus", resources);
    }

    public RemoteStatusOperation(IResourceProvider provider) {
        super("Operation.UpdateStatus", provider);
    }

    public IResource[] getScope() {
        return this.operableData();
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = FileUtility.shrinkChildNodes(this.operableData());
        final ArrayList result = new ArrayList();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(resources[i]);
            final ISVNClientWrapper proxy = location.acquireSVNProxy();
            SVNUtility.addSVNNotifyListener(proxy, this);
            final IResource current = resources[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    result.addAll(Arrays.asList(proxy.status(FileUtility.getWorkingCopyPath(current), true, true, false, false, new SVNProgressMonitor(RemoteStatusOperation.this, monitor, null, false))));
                }
            }, monitor, resources.length);
            SVNUtility.removeSVNNotifyListener(proxy, this);
            location.releaseSVNProxy(proxy);
            ++i;
        }
        this.statuses = result.toArray(new Status[result.size()]);
    }

    public Status[] getStatuses() {
        return this.statuses;
    }

    public void setPegRevision(IResourceChange change) {
        IPath resourcePath = FileUtility.getResourcePath(change.getResource());
        if (resourcePath == null) {
            return;
        }
        Iterator it = this.pegRevisions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Path rootPath = new Path((String)entry.getKey());
            if (!rootPath.isPrefixOf(resourcePath)) continue;
            change.setPegRevision((Revision)entry.getValue());
            return;
        }
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        if (change.getResource().getType() == 4) {
            IRepositoryResource remote = storage.asRepositoryResource(change.getResource());
            change.setPegRevision(remote.getPegRevision());
        }
    }

    public void onNotify(NotifyInformation info) {
        if (info.revision != -1L) {
            this.pegRevisions.put(info.path, Revision.getInstance(info.revision));
        }
    }
}

