/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.operation.local.IRemoteStatusOperation;
import org.polarion.team.svn.core.operation.local.MergeSet;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IResourceChange;
import org.polarion.team.svn.core.utility.FileUtility;

public class MergeStatusOperation
extends AbstractWorkingCopyOperation
implements IRemoteStatusOperation {
    protected MergeSet info;

    public MergeStatusOperation(MergeSet info) {
        super("Operation.MergeStatus", info.to);
        this.info = info;
    }

    public IResource[] getScope() {
        return this.info.to;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.info.setStatuses(new Status[0]);
        final ArrayList st = new ArrayList();
        int i = 0;
        while (i < this.info.to.length && !monitor.isCanceled()) {
            final IRepositoryResource from = this.info.from[i];
            final ISVNClientWrapper proxy = from.getRepositoryLocation().acquireSVNProxy();
            final String wcPath = FileUtility.getWorkingCopyPath(this.info.to[i]);
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    st.addAll(Arrays.asList(proxy.mergeStatus(from.getUrl(), from.getPegRevision(), MergeStatusOperation.this.info.start, from.getSelectedRevision(), wcPath, null, true, false, new SVNProgressMonitor(MergeStatusOperation.this, monitor, null))));
                }
            }, monitor, this.info.to.length);
            from.getRepositoryLocation().releaseSVNProxy(proxy);
            ++i;
        }
        this.info.setStatuses(st.toArray(new Status[st.size()]));
    }

    public Status[] getStatuses() {
        return this.info.getStatuses();
    }

    public void setPegRevision(IResourceChange change) {
    }
}

