/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.operation.AbstractActionOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.resource.IRepositoryFile;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class GetRemoteContentsOperation
extends AbstractActionOperation {
    protected IResource resource;
    protected IRepositoryResource remote;

    public GetRemoteContentsOperation(IResource resource, IRepositoryResource remote) {
        super("Operation.GetContent");
        this.resource = resource;
        this.remote = remote;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.resource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryLocation location = this.remote.getRepositoryLocation();
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        try {
            block13: {
                String wcPath = FileUtility.getWorkingCopyPath(this.resource);
                if (this.remote instanceof IRepositoryFile) {
                    FileOutputStream stream = null;
                    try {
                        try {
                            String url = SVNUtility.encodeURL(this.remote.getUrl());
                            this.writeToConsole(0, "svn cat " + url + "@" + this.remote.getPegRevision() + " -r " + this.remote.getSelectedRevision() + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                            byte[] data = proxy.fileContent(url, this.remote.getSelectedRevision(), this.remote.getPegRevision(), new SVNProgressMonitor(this, monitor, null));
                            stream = new FileOutputStream(wcPath);
                            stream.write(data);
                            stream.close();
                            stream = null;
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                        Object var8_11 = null;
                        if (stream == null) break block13;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        if (stream == null) throw throwable;
                        try {
                            stream.close();
                            throw throwable;
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    try {}
                    catch (Exception exception) {}
                    stream.close();
                } else {
                    String url = SVNUtility.encodeURL(this.remote.getUrl());
                    this.writeToConsole(0, "svn export " + url + "@" + this.remote.getPegRevision() + " -r " + this.remote.getSelectedRevision() + " \"" + wcPath + "\" --force " + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                    proxy.doExport(url, wcPath, this.remote.getSelectedRevision(), this.remote.getPegRevision(), true, false, true, null, new SVNProgressMonitor(this, monitor, null));
                }
            }
            Object var10_14 = null;
            location.releaseSVNProxy(proxy);
            return;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
    }

    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), this.resource.getName());
    }
}

