/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local;

import java.io.File;
import java.io.FileOutputStream;
import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.AbstractGetFileContentOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;

public class GetLocalFileContentOperation
extends AbstractGetFileContentOperation {
    protected IResource resource;
    protected Revision revision;

    public GetLocalFileContentOperation(IResource resource, int revisionKind) {
        super("Local");
        this.resource = resource;
        this.revision = revisionKind == 5 ? Revision.BASE : Revision.WORKING;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        if (this.revision.getKind() != 5) {
            this.tmpFile = new File(FileUtility.getWorkingCopyPath(this.resource));
            return;
        }
        IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(this.resource);
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        FileOutputStream stream = null;
        try {
            this.tmpFile = this.createTempFile();
            stream = new FileOutputStream(this.tmpFile);
            proxy.streamFileContent(FileUtility.getWorkingCopyPath(this.resource), this.revision, null, 2048, stream, new SVNProgressMonitor(this, monitor, null));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            location.releaseSVNProxy(proxy);
            if (stream == null) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var5_7 = null;
            location.releaseSVNProxy(proxy);
            if (stream == null) return;
            try {}
            catch (Exception exception) {
                return;
            }
            stream.close();
            return;
        }
    }

    protected String getExtension() {
        return this.resource.getFileExtension();
    }

    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), this.resource.getName());
    }
}

