/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.operation.local.change.IActionOperationProcessor;
import org.polarion.team.svn.core.operation.local.change.IResourceChangeVisitor;
import org.polarion.team.svn.core.operation.local.change.ResourceChange;
import org.polarion.team.svn.core.operation.local.change.visitors.CompositeVisitor;
import org.polarion.team.svn.core.operation.local.change.visitors.SavePropertiesVisitor;
import org.polarion.team.svn.core.operation.local.property.SetPropertiesOperation;
import org.polarion.team.svn.core.resource.ILocalFolder;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;

public class FreezeExternalsOperation
extends AbstractWorkingCopyOperation
implements IActionOperationProcessor,
IResourceProvider {
    protected ArrayList changes = new ArrayList();

    public FreezeExternalsOperation(IResource[] resources) {
        super("Operation.FreezeExternals", resources);
    }

    public FreezeExternalsOperation(IResourceProvider provider) {
        super("Operation.FreezeExternals", provider);
    }

    public IResource[] getResources() {
        return this.operableData();
    }

    public Collection getChanges() {
        return this.changes;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        final CompositeVisitor visitor = new CompositeVisitor();
        visitor.add(new SavePropertiesVisitor(true));
        visitor.add(new FreezeVisitor());
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            final IResource current = resources[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    ResourceChange change = ResourceChange.wrapLocalResource(null, SVNRemoteStorage.instance().asLocalResource(current), false);
                    if (change != null) {
                        change.traverse(visitor, 2, FreezeExternalsOperation.this, monitor);
                    }
                }
            }, monitor, resources.length);
            ++i;
        }
    }

    public void doOperation(IActionOperation op, IProgressMonitor monitor) {
        this.reportStatus(op.run(monitor).getStatus());
    }

    protected class FreezeVisitor
    implements IResourceChangeVisitor {
        protected FreezeVisitor() {
        }

        public void postVisit(ResourceChange change, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
        }

        public void preVisit(ResourceChange change, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
            PropertyData[] properties;
            if (change.getLocal() instanceof ILocalFolder && (properties = change.getProperties()) != null) {
                int i = 0;
                while (i < properties.length && !monitor.isCanceled()) {
                    if (properties[i].name.equals("svn:externals")) {
                        FreezeExternalsOperation.this.changes.add(change);
                        this.processExternals(change, properties[i], processor, monitor);
                    }
                    ++i;
                }
            }
        }

        protected void processExternals(ResourceChange change, PropertyData property, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
            String newValue = "";
            StringTokenizer tok = new StringTokenizer(property.value, "\n\r", false);
            while (tok.hasMoreTokens()) {
                String line = tok.nextToken();
                String[] entries = line.split("\\s");
                newValue = entries.length == 2 ? String.valueOf(newValue) + this.freezeExternal(change, entries[0], entries[1]) : String.valueOf(newValue) + line;
                newValue = String.valueOf(newValue) + "\n";
            }
            SetPropertiesOperation setOp = new SetPropertiesOperation(new IResource[]{change.getLocal().getResource()}, property.name, newValue.getBytes(), false);
            processor.doOperation(setOp, monitor);
        }

        protected String freezeExternal(ResourceChange change, String name, String url) {
            IContainer container = (IContainer)change.getLocal().getResource();
            ILocalResource local = SVNRemoteStorage.instance().asLocalResource(container.findMember(name));
            if (local == null) {
                return String.valueOf(name) + "\t" + url;
            }
            return String.valueOf(name) + "\t-r" + local.getRevision() + "\t" + url;
        }
    }
}

