/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.operation.IConsoleStream;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class DetectDeletedProjectsOperation
extends AbstractWorkingCopyOperation
implements IResourceProvider {
    protected ArrayList toUpdate = new ArrayList();
    protected ArrayList toDisconnect = new ArrayList();

    public DetectDeletedProjectsOperation(IResource[] resources) {
        super("Operation.DetectDeletedProjects", resources);
    }

    public DetectDeletedProjectsOperation(IResourceProvider provider) {
        super("Operation.DetectDeletedProjects", provider);
    }

    public IResource[] getResources() {
        return this.toUpdate.toArray(new IResource[this.toUpdate.size()]);
    }

    public IProject[] getDeleted() {
        return this.toDisconnect.toArray(new IProject[this.toDisconnect.size()]);
    }

    public IConsoleStream getConsoleStream() {
        return null;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        int i = 0;
        while (i < resources.length) {
            final IResource current = resources[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    if (current instanceof IProject) {
                        DetectDeletedProjectsOperation.this.checkProject(monitor, (IProject)current);
                    } else {
                        DetectDeletedProjectsOperation.this.toUpdate.add(current);
                    }
                }
            }, monitor, resources.length);
            ++i;
        }
        Iterator it = this.toUpdate.iterator();
        while (it.hasNext()) {
            IResource resource = (IResource)it.next();
            if (!this.toDisconnect.contains(resource.getProject())) continue;
            it.remove();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkProject(IProgressMonitor monitor, IProject project) throws Exception {
        IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource((IResource)project);
        IRepositoryLocation location = remote.getRepositoryLocation();
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        try {
            if (!remote.exists()) {
                String localPath = FileUtility.getWorkingCopyPath((IResource)project);
                Status[] statuses = proxy.status(localPath, false, true, false, false, new SVNProgressMonitor(this, monitor, null));
                SVNUtility.reorder(statuses, true);
                if (statuses == null || statuses.length == 0 || statuses.length > 0 && new Path(localPath).equals((Object)new Path(statuses[0].path)) && statuses[0].repositoryTextStatus == 4) {
                    this.toDisconnect.add(project);
                } else {
                    this.toUpdate.add(project);
                }
            } else {
                this.toUpdate.add(project);
            }
            Object var8_10 = null;
            location.releaseSVNProxy(proxy);
            return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
    }
}

