/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.ClientWrapperUnresolvedConflictException;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.extension.CoreExtensionsManager;
import org.polarion.team.svn.core.operation.IRevisionProvider;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.local.AbstractConflictDetectionOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class CommitOperation
extends AbstractConflictDetectionOperation
implements IRevisionProvider {
    protected boolean recursive;
    protected boolean keepLocks;
    protected String message;
    protected ArrayList revisionsPairs;
    protected String[] paths;

    public CommitOperation(IResource[] resources, String message, boolean recursive, boolean keepLocks) {
        super("Operation.Commit", resources);
        this.message = message;
        this.recursive = recursive;
        this.keepLocks = keepLocks;
    }

    public CommitOperation(IResource[] resources, String message, boolean recursive) {
        this(resources, message, recursive, false);
    }

    public CommitOperation(IResourceProvider provider, String message, boolean recursive, boolean keepLocks) {
        super("Operation.Commit", provider);
        this.message = message;
        this.recursive = recursive;
        this.keepLocks = keepLocks;
    }

    public CommitOperation(IResourceProvider provider, String message, boolean recursive) {
        this(provider, message, recursive, false);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.revisionsPairs = new ArrayList();
        IResource[] resources = this.operableData();
        this.defineInitialResourceSet(resources);
        if (this.recursive) {
            resources = FileUtility.shrinkChildNodes(resources);
        } else {
            FileUtility.reorder(resources, true);
        }
        if (CoreExtensionsManager.instance().getSVNClientWrapperFactory().isAtomicCommitAllowed()) {
            Map proxy2Resources = SVNUtility.splitRepositoryLocations(resources);
            Iterator it = proxy2Resources.entrySet().iterator();
            while (it.hasNext() && !monitor.isCanceled()) {
                Map.Entry entry = it.next();
                IRepositoryLocation location = (IRepositoryLocation)entry.getKey();
                this.performCommit(location, (List)entry.getValue(), monitor, proxy2Resources.size());
            }
        } else {
            Map project2Resources = SVNUtility.splitWorkingCopies(resources);
            SVNRemoteStorage storage = SVNRemoteStorage.instance();
            Iterator it = project2Resources.entrySet().iterator();
            while (it.hasNext() && !monitor.isCanceled()) {
                Map.Entry entry = it.next();
                IRepositoryLocation location = storage.getRepositoryLocation((IResource)entry.getKey());
                this.performCommit(location, (List)entry.getValue(), monitor, project2Resources.size());
            }
        }
    }

    protected void performCommit(final IRepositoryLocation location, List resources, final IProgressMonitor monitor, int total) {
        this.paths = FileUtility.asPathArray(resources.toArray(new IResource[0]));
        this.complexWriteToConsole(new Runnable(){

            public void run() {
                CommitOperation.this.writeToConsole(0, "svn commit");
                int i = 0;
                while (i < CommitOperation.this.paths.length && !monitor.isCanceled()) {
                    CommitOperation.this.writeToConsole(0, " \"" + CommitOperation.this.paths[i] + "\"");
                    ++i;
                }
                CommitOperation.this.writeToConsole(0, String.valueOf(CommitOperation.this.recursive ? "" : " -N") + (CommitOperation.this.keepLocks ? " --no-unlock" : "") + " -m \"" + CommitOperation.this.message + "\"" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            }
        });
        final ISVNClientWrapper proxy = location.acquireSVNProxy();
        this.protectStep(new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                long[] revisionNumbers = proxy.commit(CommitOperation.this.paths, CommitOperation.this.message, CommitOperation.this.recursive, CommitOperation.this.keepLocks, new SVNProgressMonitor(CommitOperation.this, monitor, null));
                if (revisionNumbers.length > 0) {
                    CommitOperation.this.revisionsPairs.add(new IRevisionProvider.RevisionPair(revisionNumbers[0], CommitOperation.this.paths, location));
                    String message = SVNTeamPlugin.instance().getResource("Console.CommittedRevision");
                    CommitOperation.this.writeToConsole(1, MessageFormat.format(message, String.valueOf(revisionNumbers[0])));
                }
            }
        }, monitor, total);
        location.releaseSVNProxy(proxy);
    }

    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionsPairs == null ? null : this.revisionsPairs.toArray(new IRevisionProvider.RevisionPair[this.revisionsPairs.size()]);
    }

    protected void reportError(Throwable t) {
        if (t instanceof ClientWrapperUnresolvedConflictException) {
            this.hasUnresolvedConflict = true;
            this.conflictMessage = t.getMessage();
            int i = 0;
            while (i < this.paths.length) {
                Iterator it = this.processed.iterator();
                while (it.hasNext()) {
                    IResource res = (IResource)it.next();
                    if (!FileUtility.getResourcePath(res).equals((Object)new Path(this.paths[i]))) continue;
                    it.remove();
                    this.unprocessed.add(res);
                    break;
                }
                ++i;
            }
        } else {
            super.reportError(t);
        }
    }
}

