/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.Team;
import org.polarion.team.svn.core.client.ClientWrapperException;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.ISVNProgressMonitor;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.extension.CoreExtensionsManager;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.local.AddToSVNOperation;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.utility.FileUtility;

public class AddToSVNWithPropertiesOperation
extends AddToSVNOperation {
    protected static final String BINARY_FILE = "application/octet-stream";
    protected static final String TEXT_FILE = "text/plain";

    public AddToSVNWithPropertiesOperation(IResource[] resources) {
        this(resources, false);
    }

    public AddToSVNWithPropertiesOperation(IResource[] resources, boolean isRecursive) {
        super(resources, isRecursive);
    }

    public AddToSVNWithPropertiesOperation(IResourceProvider provider, boolean isRecursive) {
        super(provider, isRecursive);
    }

    protected void doAdd(IResource current, final ISVNClientWrapper proxy, final IProgressMonitor monitor) throws Exception {
        super.doAdd(current, proxy, monitor);
        if (!this.isRecursive) {
            this.processResource(current, proxy, monitor);
        } else {
            FileUtility.visitNodes(current, new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (monitor.isCanceled()) {
                        return false;
                    }
                    try {
                        AddToSVNWithPropertiesOperation.this.processResource(resource, proxy, monitor);
                    }
                    catch (ClientWrapperException cwe) {
                        AddToSVNWithPropertiesOperation.this.reportError(cwe);
                        return false;
                    }
                    return true;
                }
            }, 2);
        }
    }

    protected void processResource(IResource resource, ISVNClientWrapper proxy, IProgressMonitor monitor) throws ClientWrapperException {
        String path = FileUtility.getWorkingCopyPath(resource);
        PropertyData[] properties = CoreExtensionsManager.instance().getOptionProvider().getAutomaticProperties(resource.getName());
        int pCount = 0;
        while (pCount < properties.length) {
            proxy.propertySet(path, properties[pCount].name, properties[pCount].value, false, (ISVNProgressMonitor)new SVNProgressMonitor(this, monitor, null));
            ++pCount;
        }
        if (resource.getType() == 1) {
            this.processFile(resource, proxy, monitor);
        }
    }

    protected void processFile(IResource resource, ISVNClientWrapper proxy, IProgressMonitor monitor) throws ClientWrapperException {
        String path = FileUtility.getWorkingCopyPath(resource);
        int i = 0;
        while (i < 2) {
            int type = i == 0 ? Team.getFileContentManager().getTypeForExtension(resource.getFileExtension() == null ? "" : resource.getFileExtension()) : Team.getFileContentManager().getTypeForName(resource.getName());
            PropertyData data = proxy.propertyGet(path, "svn:mime-type", new SVNProgressMonitor(this, monitor, null));
            if (data == null) {
                if (type == 2) {
                    proxy.propertySet(path, "svn:mime-type", BINARY_FILE, false, (ISVNProgressMonitor)new SVNProgressMonitor(this, monitor, null));
                } else if (type == 1) {
                    proxy.propertySet(path, "svn:mime-type", TEXT_FILE, false, (ISVNProgressMonitor)new SVNProgressMonitor(this, monitor, null));
                }
            }
            ++i;
        }
    }
}

