/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.file.refactor;

import java.io.File;
import java.io.FileFilter;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.UnreportableException;
import org.polarion.team.svn.core.operation.file.AbstractFileOperation;
import org.polarion.team.svn.core.operation.file.IFileProvider;
import org.polarion.team.svn.core.operation.file.SVNFileStorage;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class CopyOperation
extends AbstractFileOperation {
    protected File localTo;
    protected boolean forceNonSVN;

    public CopyOperation(File[] files, File localTo, boolean forceNonSVN) {
        super("Operation.CopyFile", files);
        this.localTo = localTo;
        this.forceNonSVN = forceNonSVN;
    }

    public CopyOperation(IFileProvider provider, File localTo, boolean forceNonSVN) {
        super("Operation.CopyFile", provider);
        this.localTo = localTo;
        this.forceNonSVN = forceNonSVN;
    }

    public ISchedulingRule getSchedulingRule() {
        ISchedulingRule parentRule = super.getSchedulingRule();
        return MultiRule.combine((ISchedulingRule)new AbstractFileOperation.LockingRule(this.localTo), (ISchedulingRule)parentRule);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        IRepositoryResource remoteTo = SVNFileStorage.instance().asRepositoryResource(this.localTo, true);
        IRepositoryLocation location = remoteTo == null ? null : remoteTo.getRepositoryLocation();
        final ISVNClientWrapper proxy = location == null ? null : location.acquireSVNProxy();
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            final File current = files[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    IRepositoryResource remote = SVNFileStorage.instance().asRepositoryResource(current, true);
                    File checked = CopyOperation.this.getCopyTo(current);
                    if (remote == null || proxy == null || CopyOperation.this.forceNonSVN) {
                        CopyOperation.this.nonSVNCopy(current, monitor);
                    } else {
                        proxy.copy(current.getAbsolutePath(), checked.getAbsolutePath(), null, Revision.WORKING, new SVNProgressMonitor(CopyOperation.this, monitor, null));
                    }
                }
            }, monitor, files.length);
            ++i;
        }
        if (location != null) {
            location.releaseSVNProxy(proxy);
        }
    }

    protected File getCopyTo(File what) {
        File checked = new File(String.valueOf(this.localTo.getAbsolutePath()) + "/" + what.getName());
        if (checked.exists()) {
            String message = this.getNationalizedString("Error.AlreadyExists");
            throw new UnreportableException(MessageFormat.format(message, checked.getAbsolutePath()));
        }
        return checked;
    }

    protected void nonSVNCopy(File what, IProgressMonitor monitor) throws Exception {
        FileUtility.copyAll(this.localTo, what, 0, new FileFilter(){

            public boolean accept(File pathname) {
                return !pathname.getName().equals(SVNUtility.getSVNFolderName());
            }
        }, monitor);
    }
}

