/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.file.property;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.file.AbstractFileOperation;
import org.polarion.team.svn.core.operation.file.IFileProvider;
import org.polarion.team.svn.core.operation.file.SVNFileStorage;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;

public class RemovePropertyOperation
extends AbstractFileOperation {
    protected boolean isRecursive;
    protected String[] names;

    public RemovePropertyOperation(File[] files, String[] names, boolean isRecursive) {
        super("Operation.RemovePropertiesFile", files);
        this.names = names;
        this.isRecursive = isRecursive;
    }

    public RemovePropertyOperation(IFileProvider provider, String[] names, boolean isRecursive) {
        super("Operation.RemovePropertiesFile", provider);
        this.names = names;
        this.isRecursive = isRecursive;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        if (this.isRecursive) {
            files = FileUtility.shrinkChildNodes(files, false);
        }
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            final File current = files[i];
            IRepositoryResource remote = SVNFileStorage.instance().asRepositoryResource(files[i], false);
            IRepositoryLocation location = remote.getRepositoryLocation();
            final ISVNClientWrapper proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    int i = 0;
                    while (i < RemovePropertyOperation.this.names.length && !monitor.isCanceled()) {
                        String name = RemovePropertyOperation.this.names[i];
                        RemovePropertyOperation.this.protectStep(new IUnprotectedOperation(this, proxy, current, name){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ ISVNClientWrapper val$proxy;
                            private final /* synthetic */ File val$current;
                            private final /* synthetic */ String val$name;
                            {
                                this.this$1 = var1_1;
                                this.val$proxy = iSVNClientWrapper;
                                this.val$current = file;
                                this.val$name = string;
                            }

                            public void run(IProgressMonitor monitor) throws Exception {
                                this.val$proxy.propertyRemove(this.val$current.getAbsolutePath(), this.val$name, 1.access$0(this.this$1).isRecursive, new SVNProgressMonitor(1.access$0(this.this$1), monitor, null));
                            }
                        }, monitor, RemovePropertyOperation.this.names.length);
                        ++i;
                    }
                }

                static /* synthetic */ RemovePropertyOperation access$0(1 var0) {
                    return var0.RemovePropertyOperation.this;
                }
            }, monitor, files.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }

    protected ISchedulingRule getSchedulingRule(File file) {
        return file.isDirectory() ? new AbstractFileOperation.LockingRule(file) : super.getSchedulingRule(file);
    }
}

