/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.file.management;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.file.AbstractFileOperation;
import org.polarion.team.svn.core.operation.file.IFileProvider;
import org.polarion.team.svn.core.resource.IRepositoryContainer;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class ShareOperation
extends AbstractFileOperation {
    public static final int LAYOUT_DEFAULT = 0;
    public static final int LAYOUT_SINGLE = 1;
    public static final int LAYOUT_MULTIPLE = 2;
    protected IRepositoryLocation location;
    protected IFolderNameMapper mapper;
    protected String rootName;
    protected int shareLayout;
    protected boolean managementFoldersEnabled;
    protected String commitComment;

    public ShareOperation(File[] files, IRepositoryLocation location, IFolderNameMapper mapper, String rootName, int shareLayout, boolean managementFoldersEnabled, String commitComment) {
        super("Operation.ShareFile", files);
        this.location = location;
        this.mapper = mapper;
        this.rootName = rootName;
        this.shareLayout = shareLayout;
        this.managementFoldersEnabled = managementFoldersEnabled;
        this.commitComment = commitComment;
    }

    public ShareOperation(IFileProvider provider, IRepositoryLocation location, IFolderNameMapper mapper, String rootName, int shareLayout, boolean managementFoldersEnabled, String commitComment) {
        super("Operation.ShareFile", provider);
        this.location = location;
        this.mapper = mapper;
        this.rootName = rootName;
        this.shareLayout = shareLayout;
        this.managementFoldersEnabled = managementFoldersEnabled;
        this.commitComment = commitComment;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        HashMap<File, IRepositoryContainer> local2remote;
        block13: {
            Iterator it;
            File[] folders = FileUtility.shrinkChildNodes(this.operableData(), true);
            local2remote = new HashMap<File, IRepositoryContainer>();
            int i = 0;
            while (true) {
                if (i >= folders.length) {
                    if (this.commitComment == null) {
                        this.commitComment = "";
                        it = local2remote.entrySet().iterator();
                        break;
                    }
                    break block13;
                }
                String url = this.getTargetUrl(this.mapper == null ? folders[i].getName() : this.mapper.getRepositoryFolderName(folders[i]), this.managementFoldersEnabled);
                IRepositoryContainer remote = this.location.asRepositoryContainer(url, false);
                local2remote.put(folders[i], remote);
                ++i;
            }
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String commentPart = ShareOperation.getDefaultComment((File)entry.getKey(), (IRepositoryContainer)entry.getValue());
                this.commitComment = String.valueOf(this.commitComment) + (this.commitComment.length() == 0 ? commentPart : "\n" + commentPart);
            }
        }
        final ISVNClientWrapper proxy = this.location.acquireSVNProxy();
        try {
            IRepositoryResource[] resourceSet = null;
            switch (this.shareLayout) {
                case 0: {
                    resourceSet = this.doDefaultLayout(local2remote);
                    break;
                }
                case 1: {
                    resourceSet = this.doSingleLayout(local2remote);
                    break;
                }
                case 2: {
                    resourceSet = this.doMultipleLayout(local2remote);
                    break;
                }
                default: {
                    String message = this.getNationalizedString("Error.UnknownProjectLayoutType");
                    throw new Exception(MessageFormat.format(message, String.valueOf(this.shareLayout)));
                }
            }
            this.mkdir(proxy, resourceSet, monitor);
            Iterator it = local2remote.entrySet().iterator();
            while (it.hasNext() && !monitor.isCanceled()) {
                final Map.Entry entry = it.next();
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        IRepositoryContainer remote = (IRepositoryContainer)entry.getValue();
                        File local = (File)entry.getKey();
                        proxy.checkout(SVNUtility.encodeURL(remote.getUrl()), local.getAbsolutePath(), Revision.HEAD, Revision.HEAD, false, true, new SVNProgressMonitor(ShareOperation.this, monitor, null));
                    }
                }, monitor, local2remote.size());
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.location.releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var8_12 = null;
            this.location.releaseSVNProxy(proxy);
            return;
        }
    }

    public static String getDefaultComment(File folder, IRepositoryResource remote) {
        String message = SVNTeamPlugin.instance().getResource("Operation.ShareFile.DefaultComment");
        return MessageFormat.format(message, folder.getName(), remote.getUrl());
    }

    public String getTargetUrl(String projectName, boolean managementFoldersEnabled) {
        return SVNUtility.normalizeURL(this.getTargetUrlImpl(projectName, managementFoldersEnabled));
    }

    protected String getTargetUrlImpl(String projectName, boolean managementFoldersEnabled) {
        String trunkName = managementFoldersEnabled ? "/" + this.getTrunkName() : "";
        switch (this.shareLayout) {
            case 0: {
                return String.valueOf(this.location.getUrl()) + trunkName + "/" + projectName;
            }
            case 1: {
                return String.valueOf(this.location.getUrl()) + "/" + projectName + trunkName;
            }
            case 2: {
                return String.valueOf(this.location.getUrl()) + "/" + this.rootName + trunkName + "/" + projectName;
            }
        }
        String message = this.getNationalizedString("Error.UnknownProjectLayoutType");
        throw new RuntimeException(MessageFormat.format(message, String.valueOf(this.shareLayout)));
    }

    protected void mkdir(ISVNClientWrapper proxy, IRepositoryResource[] resourceSet, IProgressMonitor monitor) throws Exception {
        ArrayList<String> urlsList = new ArrayList<String>();
        int i = 0;
        while (i < resourceSet.length && !monitor.isCanceled()) {
            ProgressMonitorUtility.setTaskInfo(monitor, this, resourceSet[i].getUrl());
            if (!resourceSet[i].exists()) {
                urlsList.add(SVNUtility.encodeURL(resourceSet[i].getUrl()));
            }
            ProgressMonitorUtility.progress(monitor, -1, resourceSet.length);
            ++i;
        }
        String[] urls = urlsList.toArray(new String[urlsList.size()]);
        proxy.mkdir(urls, this.commitComment, new SVNProgressMonitor(this, monitor, null));
    }

    protected IRepositoryResource[] doDefaultLayout(Map local2remote) {
        HashSet<IRepositoryResource> fullSet = new HashSet<IRepositoryResource>();
        Iterator it = local2remote.values().iterator();
        while (it.hasNext()) {
            IRepositoryContainer remote = (IRepositoryContainer)it.next();
            IRepositoryResource[] resources = SVNUtility.makeResourceSet(remote.getRepositoryLocation().getRoot(), remote);
            fullSet.addAll(Arrays.asList(resources));
        }
        return this.getOrderedSet(fullSet);
    }

    protected IRepositoryResource[] doSingleLayout(Map local2remote) {
        if (this.managementFoldersEnabled) {
            HashSet<IRepositoryResource> fullSet = new HashSet<IRepositoryResource>();
            Iterator it = local2remote.values().iterator();
            while (it.hasNext()) {
                IRepositoryContainer remote = (IRepositoryContainer)it.next();
                IRepositoryResource[] resources = SVNUtility.makeResourceSet(remote.getRepositoryLocation().getRoot(), remote);
                fullSet.addAll(Arrays.asList(resources));
                IRepositoryContainer parent = (IRepositoryContainer)remote.getParent();
                fullSet.add(this.makeChild(parent, this.getTagsName()));
                fullSet.add(this.makeChild(parent, this.getBranchesName()));
            }
            return this.getOrderedSet(fullSet);
        }
        return this.doDefaultLayout(local2remote);
    }

    protected IRepositoryResource[] doMultipleLayout(Map local2remote) {
        if (this.managementFoldersEnabled) {
            HashSet<IRepositoryResource> fullSet = new HashSet<IRepositoryResource>();
            Iterator it = local2remote.values().iterator();
            while (it.hasNext()) {
                IRepositoryContainer remote = (IRepositoryContainer)it.next();
                IRepositoryResource[] resources = SVNUtility.makeResourceSet(remote.getRepositoryLocation().getRoot(), remote);
                fullSet.addAll(Arrays.asList(resources));
                String targetUrl = this.getTargetUrl("", false);
                IRepositoryContainer parent = this.location.asRepositoryContainer(targetUrl, false);
                fullSet.add(this.makeChild(parent, this.getTagsName()));
                fullSet.add(this.makeChild(parent, this.getBranchesName()));
            }
            return this.getOrderedSet(fullSet);
        }
        return this.doDefaultLayout(local2remote);
    }

    protected IRepositoryContainer makeChild(IRepositoryContainer parent, String name) {
        return this.location.asRepositoryContainer(String.valueOf(parent.getUrl()) + "/" + name, false);
    }

    protected IRepositoryResource[] getOrderedSet(Set fullSet) {
        Object[] resources = fullSet.toArray(new IRepositoryResource[fullSet.size()]);
        FileUtility.sort(resources, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                IRepositoryResource first = (IRepositoryResource)arg0;
                IRepositoryResource second = (IRepositoryResource)arg1;
                return first.getUrl().compareTo(second.getUrl());
            }
        });
        return resources;
    }

    protected String getTrunkName() {
        if (this.location.isStructureEnabled()) {
            return this.location.getTrunkLocation();
        }
        return SVNTeamPlugin.instance().getOptionProvider().getDefaultTrunkName();
    }

    protected String getBranchesName() {
        if (this.location.isStructureEnabled()) {
            return this.location.getBranchesLocation();
        }
        return SVNTeamPlugin.instance().getOptionProvider().getDefaultBranchesName();
    }

    protected String getTagsName() {
        if (this.location.isStructureEnabled()) {
            return this.location.getTagsLocation();
        }
        return SVNTeamPlugin.instance().getOptionProvider().getDefaultTagsName();
    }

    public static interface IFolderNameMapper {
        public String getRepositoryFolderName(File var1);
    }
}

