/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.file.management;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.file.AbstractFileOperation;
import org.polarion.team.svn.core.operation.file.IFileProvider;
import org.polarion.team.svn.core.operation.file.SVNFileStorage;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;

public class CleanupOperation
extends AbstractFileOperation {
    public CleanupOperation(File[] files) {
        super("Operation.CleanupFile", files);
    }

    public CleanupOperation(IFileProvider provider) {
        super("Operation.CleanupFile", provider);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        SVNFileStorage storage = SVNFileStorage.instance();
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            IRepositoryResource remote = storage.asRepositoryResource(files[i], false);
            IRepositoryLocation location = remote.getRepositoryLocation();
            final ISVNClientWrapper proxy = location.acquireSVNProxy();
            final String current = files[i].getAbsolutePath();
            ProgressMonitorUtility.setTaskInfo(monitor, this, current);
            this.writeToConsole(0, "svn cleanup \"" + FileUtility.normalizePath(current) + "\"\n");
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.cleanup(current, new SVNProgressMonitor(CleanupOperation.this, monitor, null));
                }
            }, monitor, files.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }
}

