/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.file;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.file.AbstractFileOperation;
import org.polarion.team.svn.core.operation.file.IFileProvider;
import org.polarion.team.svn.core.operation.file.SVNFileStorage;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class UnlockOperation
extends AbstractFileOperation {
    public UnlockOperation(File[] files) {
        super("Operation.UnlockFile", files);
    }

    public UnlockOperation(IFileProvider provider) {
        super("Operation.UnlockFile", provider);
    }

    protected void runImpl(final IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        Map wc2Resources = SVNUtility.splitWorkingCopies(files);
        Iterator it = wc2Resources.entrySet().iterator();
        while (it.hasNext() && !monitor.isCanceled()) {
            Map.Entry entry = it.next();
            IRepositoryResource wcRoot = SVNFileStorage.instance().asRepositoryResource((File)entry.getKey(), false);
            final IRepositoryLocation location = wcRoot.getRepositoryLocation();
            final String[] paths = FileUtility.asPathArray(((List)entry.getValue()).toArray(new File[0]));
            this.complexWriteToConsole(new Runnable(){

                public void run() {
                    UnlockOperation.this.writeToConsole(0, "svn unlock");
                    int i = 0;
                    while (i < paths.length && !monitor.isCanceled()) {
                        UnlockOperation.this.writeToConsole(0, " \"" + paths[i] + "\"");
                        ++i;
                    }
                    UnlockOperation.this.writeToConsole(0, " --force" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                }
            });
            final ISVNClientWrapper proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.unlock(paths, true, new SVNProgressMonitor(UnlockOperation.this, monitor, null));
                }
            }, monitor, wc2Resources.size());
            location.releaseSVNProxy(proxy);
        }
    }
}

