/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.file;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.file.AbstractFileOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class SwitchOperation
extends AbstractFileOperation {
    protected IRepositoryResource destination;

    public SwitchOperation(File file, IRepositoryResource destination) {
        super("Operation.SwitchFile", new File[]{file});
        this.destination = destination;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File file = this.operableData()[0];
        IRepositoryLocation location = this.destination.getRepositoryLocation();
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        this.writeToConsole(0, "svn switch \"" + this.destination.getUrl() + "\" \"" + FileUtility.normalizePath(file.getAbsolutePath()) + "\" -r " + this.destination.getSelectedRevision() + FileUtility.getUsernameParam(location.getUsername()) + "\n");
        try {
            proxy.doSwitch(file.getAbsolutePath(), SVNUtility.encodeURL(this.destination.getUrl()), this.destination.getSelectedRevision(), true, new SVNProgressMonitor(this, monitor, null));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var5_7 = null;
            location.releaseSVNProxy(proxy);
            return;
        }
    }
}

