/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.file;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Info2;
import org.polarion.team.svn.core.extension.CoreExtensionsManager;
import org.polarion.team.svn.core.operation.file.IFileStorage;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.svnstorage.AbstractSVNStorage;
import org.polarion.team.svn.core.utility.SVNUtility;

public class SVNFileStorage
extends AbstractSVNStorage
implements IFileStorage {
    public static final String STATE_INFO_FILE_NAME = ".externalSVNRepositories";
    private static SVNFileStorage instance = new SVNFileStorage();

    public static SVNFileStorage instance() {
        return instance;
    }

    public void initialize(IPath stateInfoLocation) throws Exception {
        this.initializeImpl(stateInfoLocation, STATE_INFO_FILE_NAME);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRepositoryResource asRepositoryResource(File file, boolean allowsNull) {
        IRepositoryResource iRepositoryResource;
        File wcRoot = file;
        Info2 info = null;
        ISVNClientWrapper proxy = CoreExtensionsManager.instance().getSVNClientWrapperFactory().newInstance();
        try {
            while (info == null) {
                if (wcRoot == null) {
                    if (!allowsNull) throw new RuntimeException(String.valueOf(file.getAbsolutePath()) + " is not under version control");
                    Object var6_6 = null;
                    proxy.dispose();
                    return null;
                }
                info = SVNUtility.getSVNInfo(wcRoot, proxy);
                if (info != null) continue;
                wcRoot = wcRoot.getParentFile();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            proxy.dispose();
            throw throwable;
        }
        {
            Object var6_8 = null;
            proxy.dispose();
        }
        String wcUrl = SVNUtility.decodeURL(info.url);
        String rootUrl = SVNUtility.decodeURL(info.reposRootUrl);
        IRepositoryLocation location = this.findLocation(wcUrl, rootUrl);
        if (wcRoot != file) {
            wcUrl = String.valueOf(wcUrl) + file.getAbsolutePath().substring(wcRoot.getAbsolutePath().length());
        }
        if (file.isFile()) {
            iRepositoryResource = location.asRepositoryFile(wcUrl, allowsNull);
            return iRepositoryResource;
        }
        iRepositoryResource = location.asRepositoryContainer(wcUrl, allowsNull);
        return iRepositoryResource;
    }

    protected IRepositoryLocation findLocation(String resourceUrl, String rootUrl) {
        Path url = new Path(resourceUrl);
        IRepositoryLocation[] locations = this.getRepositoryLocations();
        int i = 0;
        while (i < locations.length) {
            if (new Path(locations[i].getUrl()).isPrefixOf((IPath)url)) {
                return locations[i];
            }
            ++i;
        }
        i = 0;
        while (i < locations.length) {
            if (locations[i].getRepositoryRootUrl().equals(rootUrl)) {
                return locations[i];
            }
            ++i;
        }
        IRepositoryLocation location = this.newRepositoryLocation(";" + rootUrl);
        this.addRepositoryLocation(location);
        return location;
    }

    private SVNFileStorage() {
    }

    protected IRepositoryLocation wrapLocationIfRequired(IRepositoryLocation location, String url, boolean isFile) {
        return location;
    }
}

