/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.file;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.file.AbstractFileOperation;
import org.polarion.team.svn.core.operation.file.IFileProvider;
import org.polarion.team.svn.core.operation.file.SVNFileStorage;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class LockOperation
extends AbstractFileOperation {
    protected String message;
    protected boolean force;

    public LockOperation(File[] files, String message, boolean force) {
        super("Operation.LockFile", files);
        this.message = message;
        this.force = force;
    }

    public LockOperation(IFileProvider provider, String message, boolean force) {
        super("Operation.LockFile", provider);
        this.message = message;
        this.force = force;
    }

    protected void runImpl(final IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        Map wc2Resources = SVNUtility.splitWorkingCopies(files);
        Iterator it = wc2Resources.entrySet().iterator();
        while (it.hasNext() && !monitor.isCanceled()) {
            Map.Entry entry = it.next();
            IRepositoryResource wcRoot = SVNFileStorage.instance().asRepositoryResource((File)entry.getKey(), false);
            final IRepositoryLocation location = wcRoot.getRepositoryLocation();
            final String[] paths = FileUtility.asPathArray(((List)entry.getValue()).toArray(new File[0]));
            this.complexWriteToConsole(new Runnable(){

                public void run() {
                    LockOperation.this.writeToConsole(0, "svn lock");
                    int i = 0;
                    while (i < paths.length && !monitor.isCanceled()) {
                        LockOperation.this.writeToConsole(0, " \"" + paths[i] + "\"");
                        ++i;
                    }
                    LockOperation.this.writeToConsole(0, String.valueOf(LockOperation.this.force ? " --force" : "") + " -m \"" + LockOperation.this.message + "\"" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                }
            });
            final ISVNClientWrapper proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.lock(paths, LockOperation.this.message, LockOperation.this.force, new SVNProgressMonitor(LockOperation.this, monitor, null));
                }
            }, monitor, wc2Resources.size());
            location.releaseSVNProxy(proxy);
        }
    }
}

