/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.file;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.file.AbstractFileOperation;
import org.polarion.team.svn.core.operation.file.IFileProvider;
import org.polarion.team.svn.core.operation.file.SVNFileStorage;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.SVNUtility;

public class GetAllFilesOperation
extends AbstractFileOperation
implements IFileProvider {
    protected File[] children;

    public GetAllFilesOperation(File file) {
        super("Operation.GetAllFiles", new File[]{file});
    }

    public File[] getFiles() {
        return this.children;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource remote;
        this.children = new File[0];
        File file = this.operableData()[0];
        if (!file.exists() || file.isFile()) {
            return;
        }
        HashSet<File> allFiles = new HashSet<File>();
        File[] children = file.listFiles(new FileFilter(){

            public boolean accept(File arg0) {
                return !arg0.getName().equals(SVNUtility.getSVNFolderName());
            }
        });
        if (children != null) {
            allFiles.addAll(Arrays.asList(children));
        }
        if ((remote = SVNFileStorage.instance().asRepositoryResource(file, true)) != null) {
            IRepositoryLocation location = remote.getRepositoryLocation();
            ISVNClientWrapper proxy = location.acquireSVNProxy();
            try {
                Status[] statuses = proxy.status(file.getAbsolutePath(), false, false, true, true, false, false, new SVNProgressMonitor(this, monitor, null));
                if (statuses != null) {
                    int i = 0;
                    while (i < statuses.length) {
                        allFiles.add(new File(statuses[i].path));
                        ++i;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                location.releaseSVNProxy(proxy);
                throw throwable;
            }
            {
                Object var10_12 = null;
                location.releaseSVNProxy(proxy);
            }
        }
        this.children = allFiles.toArray(new File[allFiles.size()]);
    }
}

