/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.file;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.file.AbstractFileOperation;
import org.polarion.team.svn.core.operation.file.SVNFileStorage;
import org.polarion.team.svn.core.resource.IRepositoryResource;

public class CreatePatchOperation
extends AbstractFileOperation {
    protected String fileName;
    protected boolean recurse;
    protected boolean ignoreDeleted;
    protected boolean processBinary;
    protected boolean processUnversioned;
    protected boolean useRelativePath;

    public CreatePatchOperation(File file, String fileName, boolean recurse, boolean ignoreDeleted, boolean processBinary, boolean processUnversioned, boolean useRelativePath) {
        super("Operation.CreatePatchFile", new File[]{file});
        this.fileName = fileName;
        this.recurse = recurse;
        this.ignoreDeleted = ignoreDeleted;
        this.processBinary = processBinary;
        this.processUnversioned = processUnversioned;
        this.useRelativePath = useRelativePath;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File file = this.operableData()[0];
        IRepositoryResource remote = SVNFileStorage.instance().asRepositoryResource(file, false);
        ISVNClientWrapper proxy = remote.getRepositoryLocation().acquireSVNProxy();
        try {
            this.writeToConsole(0, "svn diff " + (this.recurse ? "" : " -N") + (this.ignoreDeleted ? " --no-diff-deleted" : "") + "\n");
            proxy.diff(file.getAbsolutePath(), Revision.BASE, null, file.getAbsolutePath(), Revision.WORKING, null, this.fileName, this.recurse, true, this.ignoreDeleted, this.processBinary, this.processUnversioned, this.useRelativePath, new SVNProgressMonitor(this, monitor, null));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            remote.getRepositoryLocation().releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var5_7 = null;
            remote.getRepositoryLocation().releaseSVNProxy(proxy);
            return;
        }
    }
}

