/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.file.AbstractFileOperation;
import org.polarion.team.svn.core.operation.file.IFileProvider;
import org.polarion.team.svn.core.operation.file.SVNFileStorage;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;

public abstract class AbstractStatusOperation
extends AbstractFileOperation {
    protected Status[] statuses;
    protected boolean recursive;

    public AbstractStatusOperation(String operationName, File[] files, boolean recursive) {
        super(operationName, files);
        this.recursive = recursive;
    }

    public AbstractStatusOperation(String operationName, IFileProvider provider, boolean recursive) {
        super(operationName, provider);
        this.recursive = recursive;
    }

    public Status[] getStatuses() {
        return this.statuses;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            IRepositoryResource remote = SVNFileStorage.instance().asRepositoryResource(files[i], false);
            IRepositoryLocation location = remote.getRepositoryLocation();
            ISVNClientWrapper proxy = location.acquireSVNProxy();
            this.reportStatuses(proxy, result, files[i], monitor, files.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
        this.statuses = result.toArray(new Status[result.size()]);
    }

    protected void reportStatuses(final ISVNClientWrapper proxy, final List result, final File current, IProgressMonitor monitor, int tasks) {
        this.protectStep(new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                result.addAll(Arrays.asList(proxy.status(current.getAbsolutePath(), AbstractStatusOperation.this.recursive, AbstractStatusOperation.this.isRemote(), false, false, new SVNProgressMonitor(AbstractStatusOperation.this, monitor, null, false))));
            }
        }, monitor, tasks);
    }

    protected abstract boolean isRemote();
}

