/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.ISVNProgressMonitor;
import org.polarion.team.svn.core.client.NotifyStatus;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.IConsoleStream;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;

public class SVNProgressMonitor
implements ISVNProgressMonitor {
    protected IProgressMonitor monitor;
    protected IActionOperation parent;
    protected IConsoleStream stream;
    protected IPath root;
    protected boolean enableConsoleOutput;

    public SVNProgressMonitor(IActionOperation parent, IProgressMonitor monitor, IPath root) {
        this(parent, monitor, root, true);
    }

    public SVNProgressMonitor(IActionOperation parent, IProgressMonitor monitor, IPath root, boolean enableConsoleOutput) {
        this.monitor = monitor;
        this.parent = parent;
        this.root = root;
        this.stream = parent.getConsoleStream();
        this.enableConsoleOutput = enableConsoleOutput;
    }

    public void progress(int current, int total, ISVNProgressMonitor.ItemState state) {
        if (state != null && state.path != null) {
            ProgressMonitorUtility.setTaskInfo(this.monitor, this.parent, state.path);
            if (this.enableConsoleOutput) {
                SVNProgressMonitor.writeToConsole(this.stream, state.contentState, state.propState, state.action, state.path, state.revision);
            }
        }
        ProgressMonitorUtility.progress(this.monitor, current, total);
    }

    public boolean isActivityCancelled() {
        return this.monitor.isCanceled();
    }

    public static void writeToConsole(IConsoleStream stream, int contentState, int propState, int action, String path, long revision) {
        if (stream != null && path != null && path.length() > 0) {
            if (action == 11 || action == 13) {
                String message = SVNTeamPlugin.instance().getResource("Console.AtRevision");
                stream.write(1, MessageFormat.format(message, String.valueOf(revision)));
            } else {
                int severity = 1;
                String status = null;
                switch (action) {
                    case 0: 
                    case 9: 
                    case 16: {
                        status = SVNTeamPlugin.instance().getResource("Console.Action.Added");
                        break;
                    }
                    case 2: 
                    case 8: 
                    case 17: {
                        status = SVNTeamPlugin.instance().getResource("Console.Action.Deleted");
                        break;
                    }
                    case 10: {
                        int resourceState = contentState == 0 || contentState == 2 ? propState : contentState;
                        int n = severity = contentState == 7 || contentState == 8 || contentState == 4 || propState == 7 || propState == 8 ? 2 : 1;
                        if (resourceState >= 0 && resourceState < NotifyStatus.shortStatusNames.length && (status = SVNTeamPlugin.instance().getResource("Console.Update.Status." + NotifyStatus.statusNames[resourceState])).length() > 0) break;
                        status = " ";
                        break;
                    }
                    case 15: {
                        status = SVNTeamPlugin.instance().getResource("Console.Action.Modified");
                        break;
                    }
                    case 18: {
                        status = SVNTeamPlugin.instance().getResource("Console.Action.Replaced");
                        break;
                    }
                    case 4: {
                        status = SVNTeamPlugin.instance().getResource("Console.Action.Reverted");
                        break;
                    }
                    case 3: {
                        status = SVNTeamPlugin.instance().getResource("Console.Action.Restored");
                        break;
                    }
                    case 21: {
                        status = SVNTeamPlugin.instance().getResource("Console.Action.Locked");
                        break;
                    }
                    case 22: {
                        status = SVNTeamPlugin.instance().getResource("Console.Action.Unlocked");
                        break;
                    }
                    default: {
                        int resourceState = contentState == 1 ? propState : contentState;
                        status = SVNProgressMonitor.getStatus(resourceState);
                        int n = severity = resourceState == 9 || resourceState == 10 ? 2 : 1;
                    }
                }
                if (action == 19) {
                    String message = SVNTeamPlugin.instance().getResource("Console.TransmittingData");
                    stream.write(severity, MessageFormat.format(message, path));
                } else if (status != null) {
                    String message = SVNTeamPlugin.instance().getResource("Console.Status");
                    stream.write(severity, MessageFormat.format(message, status, path));
                }
            }
        }
    }

    protected static String getStatus(int resourceState) {
        switch (resourceState) {
            case 3: {
                return SVNTeamPlugin.instance().getResource("Console.Status.Added");
            }
            case 2: {
                return SVNTeamPlugin.instance().getResource("Console.Status.Modified");
            }
            case 4: {
                return SVNTeamPlugin.instance().getResource("Console.Status.Deleted");
            }
            case 6: {
                return SVNTeamPlugin.instance().getResource("Console.Status.Missing");
            }
            case 7: {
                return SVNTeamPlugin.instance().getResource("Console.Status.Replaced");
            }
            case 8: {
                return SVNTeamPlugin.instance().getResource("Console.Status.Merged");
            }
            case 9: {
                return SVNTeamPlugin.instance().getResource("Console.Status.Conflicted");
            }
            case 10: {
                return SVNTeamPlugin.instance().getResource("Console.Status.Obstructed");
            }
        }
        return null;
    }
}

