/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;

public abstract class AbstractGetFileContentOperation
extends AbstractNonLockingOperation {
    protected File tmpFile;

    public AbstractGetFileContentOperation(String getOperationType) {
        super("Operation.GetFileContent." + getOperationType);
    }

    public String getTemporaryPath() {
        return this.tmpFile == null ? null : this.tmpFile.getAbsolutePath();
    }

    public InputStream getContent() {
        final InputStream[] retVal = new InputStream[]{new ByteArrayInputStream(new byte[0])};
        if (this.tmpFile != null && this.tmpFile.exists()) {
            ProgressMonitorUtility.doTaskExternal(new AbstractNonLockingOperation("Operation.GetFileContent.CreateStream"){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    retVal[0] = new FileInputStream(AbstractGetFileContentOperation.this.tmpFile);
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        return retVal[0];
    }

    public void setContent(final byte[] data) {
        ProgressMonitorUtility.doTaskExternal(new AbstractNonLockingOperation("Operation.GetFileContent.SetContent"){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void runImpl(IProgressMonitor monitor) throws Exception {
                if (AbstractGetFileContentOperation.this.tmpFile == null) {
                    AbstractGetFileContentOperation.this.tmpFile = AbstractGetFileContentOperation.this.createTempFile();
                }
                FileOutputStream stream = new FileOutputStream(AbstractGetFileContentOperation.this.tmpFile);
                try {
                    stream.write(data);
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                try {}
                catch (Exception exception) {
                    return;
                }
                stream.close();
            }
        }, (IProgressMonitor)new NullProgressMonitor());
    }

    protected File createTempFile() throws IOException {
        String extension = this.getExtension();
        File retVal = File.createTempFile("getfilecontent", ".tmp" + (extension != null && extension.length() > 0 ? "." + extension : ""), SVNTeamPlugin.instance().getStateLocation().toFile());
        retVal.deleteOnExit();
        return retVal;
    }

    protected String getExtension() {
        return "";
    }
}

