/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.history;

import java.net.URI;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.history.ResourceContentStorage;
import org.polarion.team.svn.core.history.SVNRemoteResourceRevision;
import org.polarion.team.svn.core.operation.AbstractGetFileContentOperation;
import org.polarion.team.svn.core.operation.local.GetLocalFileContentOperation;
import org.polarion.team.svn.core.operation.remote.GetLogMessagesOperation;
import org.polarion.team.svn.core.resource.ILocalFolder;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;

public class SVNLocalResourceRevision
extends FileRevision {
    protected ILocalResource local;
    protected boolean onServer;
    protected Revision rev;

    public SVNLocalResourceRevision(ILocalResource local, Revision rev) {
        this.local = local;
        this.onServer = IStateFilter.SF_ONREPOSITORY.accept(this.local.getResource(), this.local.getStatus(), this.local.getChangeMask());
    }

    public URI getURI() {
        return this.local.getResource().getLocationURI();
    }

    public long getTimestamp() {
        return !this.onServer ? -1L : this.local.getLastCommitDate();
    }

    public boolean exists() {
        return true;
    }

    public String getContentIdentifier() {
        return !this.onServer ? null : String.valueOf(this.local.getRevision());
    }

    public String getAuthor() {
        return this.local.getAuthor();
    }

    public String getComment() {
        return null;
    }

    public String getName() {
        return this.local.getName();
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        if (this.local instanceof ILocalFolder) {
            return null;
        }
        if (IStateFilter.SF_NONVERSIONED.accept(this.local.getResource(), this.local.getStatus(), this.local.getChangeMask()) && !IStateFilter.SF_PREREPLACED.accept(this.local.getResource(), this.local.getStatus(), this.local.getChangeMask())) {
            return (IStorage)this.local.getResource();
        }
        return new LocalStorage();
    }

    public boolean isPropertyMissing() {
        return this.onServer;
    }

    public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
        if (!this.onServer) {
            return this;
        }
        IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource(this.local.getResource());
        remote.setSelectedRevision(Revision.getInstance(this.local.getRevision()));
        GetLogMessagesOperation log = new GetLogMessagesOperation(remote);
        log.setLimit(1L);
        ProgressMonitorUtility.doTaskExternal(log, monitor);
        if (log.getExecutionState() == 0 && log.getMessages().length > 0) {
            return new SVNRemoteResourceRevision(remote, log.getMessages()[0]);
        }
        return null;
    }

    protected class LocalStorage
    extends ResourceContentStorage {
        public LocalStorage() {
            super(SVNRemoteStorage.instance().asRepositoryResource(SVNLocalResourceRevision.this.local.getResource()));
        }

        public IPath getFullPath() {
            return SVNLocalResourceRevision.this.local.getResource().getLocation();
        }

        protected AbstractGetFileContentOperation getLoadContentOperation() {
            return new GetLocalFileContentOperation(SVNLocalResourceRevision.this.local.getResource(), SVNLocalResourceRevision.this.rev.getKind());
        }
    }
}

