/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.extension;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.extension.crashrecovery.IResolutionHelper;
import org.polarion.team.svn.core.extension.factory.ISVNClientWrapperFactory;
import org.polarion.team.svn.core.extension.factory.ThreadNameModifierFactory;
import org.polarion.team.svn.core.extension.options.IIgnoreRecommendations;
import org.polarion.team.svn.core.extension.options.IOptionProvider;
import org.polarion.team.svn.core.operation.LoggedOperation;

public class CoreExtensionsManager {
    public static final String EXTENSION_NAMESPACE = "org.polarion.team.svn.core";
    public static final String CLIENT_LIBRARY = "svnclient";
    public static final String CORE_OPTIONS = "coreoptions";
    public static final String CRASH_RECOVERY = "crashrecovery";
    public static final String IGNORE_RECOMMENDATIONS = "resourceIgnoreRules";
    private HashMap clients = new HashMap();
    private HashSet validClients = new HashSet();
    private IOptionProvider optionProvider;
    private IResolutionHelper[] helpers;
    private IIgnoreRecommendations[] ignoreRecommendations;
    private static CoreExtensionsManager instance;
    private boolean disableHelpers = false;

    public static synchronized CoreExtensionsManager instance() {
        if (instance == null) {
            instance = new CoreExtensionsManager();
        }
        return instance;
    }

    public IIgnoreRecommendations[] getIgnoreRecommendations() {
        return this.ignoreRecommendations;
    }

    public IResolutionHelper[] getResolutionHelpers() {
        return this.disableHelpers ? new IResolutionHelper[]{} : this.helpers;
    }

    public void setResolutionHelpersDisabled(boolean disable) {
        this.disableHelpers = disable;
    }

    public boolean isResoultionHelpersDisabled() {
        return this.disableHelpers;
    }

    public IOptionProvider getOptionProvider() {
        return this.optionProvider;
    }

    public void setOptionProvider(IOptionProvider optionProvider) {
        this.optionProvider = optionProvider;
    }

    public Collection getAccessibleClientIds() {
        return this.clients.keySet();
    }

    public Collection getAccessibleClients() {
        return this.clients.values();
    }

    public ISVNClientWrapperFactory getSVNClientWrapperFactory() {
        String id = SVNTeamPlugin.instance().getOptionProvider().getSVNClientId();
        return this.getSVNClientWrapperFactory(id);
    }

    public ISVNClientWrapperFactory getSVNClientWrapperFactory(String id) {
        ISVNClientWrapperFactory retVal = ISVNClientWrapperFactory.EMPTY;
        if (this.validClients.contains(id)) {
            retVal = (ISVNClientWrapperFactory)this.clients.get(id);
        }
        return retVal;
    }

    private CoreExtensionsManager() {
        Object[] extensions = this.loadCoreExtensions(CLIENT_LIBRARY);
        int i = 0;
        while (i < extensions.length) {
            block4: {
                ThreadNameModifierFactory factory = new ThreadNameModifierFactory((ISVNClientWrapperFactory)extensions[i]);
                try {
                    if (factory.getCompatibilityVersion().compareTo("1.1.3") != 0) {
                    }
                }
                catch (Throwable throwable) {}
                break block4;
                this.clients.put(factory.getId(), factory);
                this.validateClient(factory);
            }
            ++i;
        }
        extensions = this.loadCoreExtensions(CORE_OPTIONS);
        this.optionProvider = extensions.length != 0 ? (IOptionProvider)extensions[0] : IOptionProvider.DEFAULT;
        extensions = this.loadCoreExtensions(CRASH_RECOVERY);
        this.helpers = Arrays.asList(extensions).toArray(new IResolutionHelper[extensions.length]);
        extensions = this.loadCoreExtensions(IGNORE_RECOMMENDATIONS);
        this.ignoreRecommendations = Arrays.asList(extensions).toArray(new IIgnoreRecommendations[extensions.length]);
    }

    private void validateClient(ISVNClientWrapperFactory client) {
        try {
            client.newInstance().dispose();
            this.validClients.add(client.getId());
        }
        catch (Throwable throwable) {}
    }

    private Object[] loadCoreExtensions(String extensionPoint) {
        return this.loadExtensions(EXTENSION_NAMESPACE, extensionPoint);
    }

    private Object[] loadExtensions(String namespace, String extensionPoint) {
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(namespace, extensionPoint);
        if (extension == null) {
            String errMessage = SVNTeamPlugin.instance().getResource("Error.InvalidExtensionPoint");
            throw new RuntimeException(MessageFormat.format(errMessage, namespace, extensionPoint));
        }
        IExtension[] extensions = extension.getExtensions();
        ArrayList<Object> retVal = new ArrayList<Object>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                try {
                    retVal.add(configElements[j].createExecutableExtension("class"));
                }
                catch (CoreException ex) {
                    LoggedOperation.reportError(SVNTeamPlugin.instance().getResource("Error.LoadExtensions"), ex);
                }
                ++j;
            }
            ++i;
        }
        return retVal.toArray();
    }
}

