/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core;

import java.io.File;
import java.io.FileFilter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.RepositoryProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.polarion.team.svn.core.ProjectCloseListener;
import org.polarion.team.svn.core.ResourceChangeListener;
import org.polarion.team.svn.core.SVNFolderListener;
import org.polarion.team.svn.core.extension.CoreExtensionsManager;
import org.polarion.team.svn.core.extension.crashrecovery.DefaultErrorHandlingFacility;
import org.polarion.team.svn.core.extension.crashrecovery.IErrorHandlingFacility;
import org.polarion.team.svn.core.extension.options.IOptionProvider;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.LoggedOperation;
import org.polarion.team.svn.core.operation.file.SVNFileStorage;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;

public class SVNTeamPlugin
extends Plugin {
    public static final String NATURE_ID = "org.polarion.team.svn.core.svnnature";
    public static final String CORE_SVNCLIENT_NAME = "svnclient";
    private static volatile SVNTeamPlugin instance = null;
    private ProjectCloseListener pcListener;
    private ResourceChangeListener rcListener;
    private SVNFolderListener svnListener;
    private IErrorHandlingFacility errorHandlingFacility;

    public SVNTeamPlugin() {
        instance = this;
        this.pcListener = new ProjectCloseListener();
        this.rcListener = new ResourceChangeListener();
        this.svnListener = new SVNFolderListener();
        this.errorHandlingFacility = new DefaultErrorHandlingFacility();
    }

    public static SVNTeamPlugin instance() {
        while (instance == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        return instance;
    }

    public String getResource(String key) {
        return FileUtility.getResource(Platform.getResourceBundle((Bundle)this.getBundle()), key);
    }

    public IOptionProvider getOptionProvider() {
        return CoreExtensionsManager.instance().getOptionProvider();
    }

    public IErrorHandlingFacility getErrorHandlingFacility() {
        return this.errorHandlingFacility;
    }

    public void setOptionProvider(IOptionProvider optionProvider) {
        CoreExtensionsManager.instance().setOptionProvider(optionProvider == null ? IOptionProvider.DEFAULT : optionProvider);
        SVNRemoteStorage.instance().reconfigureLocations();
        ProgressMonitorUtility.doTaskScheduledDefault(new AbstractNonLockingOperation("Remove Temporary Files"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                SVNTeamPlugin.instance().getStateLocation().toFile().listFiles(new FileFilter(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public boolean accept(File pathname) {
                        String name = pathname.getName();
                        if (!name.equals(".svnRepositories") && !name.equals(".externalSVNRepositories")) {
                            FileUtility.deleteRecursive(pathname);
                        }
                        return false;
                    }
                });
            }
        });
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IPath stateLocation = this.getStateLocation();
        SVNFileStorage.instance().initialize(stateLocation);
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        storage.initialize(stateLocation);
        if (storage.getRepositoryLocations().length == 0) {
            String coreFolderName = stateLocation.lastSegment();
            IPath uiLocation = stateLocation.removeLastSegments(1).append(String.valueOf(coreFolderName.substring(0, coreFolderName.length() - 4)) + "ui");
            File previousStore = new File(uiLocation + "/" + ".svnRepositories");
            if (previousStore.exists()) {
                FileUtility.copyFile(new File(String.valueOf(stateLocation.toString()) + "/" + ".svnRepositories"), previousStore, (IProgressMonitor)new NullProgressMonitor());
                previousStore.delete();
                storage.initialize(stateLocation);
            }
        }
        WorkspaceJob job = new WorkspaceJob(""){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                workspace.addResourceChangeListener((IResourceChangeListener)SVNTeamPlugin.this.rcListener, 1);
                workspace.addResourceChangeListener((IResourceChangeListener)SVNTeamPlugin.this.svnListener, 8);
                workspace.addResourceChangeListener((IResourceChangeListener)SVNTeamPlugin.this.pcListener, 6);
                try {
                    SVNTeamPlugin.this.rcListener.handleInitialWorkspaceDelta();
                }
                catch (Throwable ex) {
                    LoggedOperation.reportError("Handle Initial Workspace Delta", ex);
                }
                IProject[] projects = workspace.getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    RepositoryProvider.getProvider((IProject)projects[i]);
                    ++i;
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        job.setUser(false);
        job.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.svnListener);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.rcListener);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.pcListener);
        SVNRemoteStorage.instance().dispose();
        SVNFileStorage.instance().dispose();
        File temporaryFilesStorage = SVNTeamPlugin.instance().getStateLocation().toFile();
        File[] files = temporaryFilesStorage.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith("tmp");
            }
        });
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                FileUtility.deleteRecursive(files[i]);
                ++i;
            }
        }
        super.stop(context);
    }
}

