/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.operation.LoggedOperation;
import org.polarion.team.svn.core.operation.local.management.ReconnectProjectOperation;
import org.polarion.team.svn.core.resource.IRepositoryRoot;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class SVNFolderListener
implements IResourceChangeListener {
    public void resourceChanged(final IResourceChangeEvent event) {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    event.getDelta().accept(new IResourceDeltaVisitor(this, monitor){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IProgressMonitor val$monitor;
                        {
                            this.this$1 = var1_1;
                            this.val$monitor = iProgressMonitor;
                        }

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            String url;
                            IRepositoryRoot[] roots;
                            Status info;
                            IResource resource = delta.getResource();
                            if (!resource.isAccessible()) {
                                return false;
                            }
                            if (resource.getType() == 8) {
                                return true;
                            }
                            if (resource.getType() == 4 && (delta.getKind() == 1 || delta.getKind() == 4) && delta.getFlags() == 16384 && SVNTeamPlugin.instance().getOptionProvider().isAutomaticProjectShareEnabled() && ((IProject)resource).isOpen() && (info = SVNUtility.getSVNInfoForNotConnected(resource)) != null && info.url != null && (roots = SVNUtility.findRoots(url = SVNUtility.decodeURL(info.url), true)) != null && roots.length == 1) {
                                ProgressMonitorUtility.doTaskExternalDefault(new ReconnectProjectOperation(new IProject[]{(IProject)resource}, roots[0].getRepositoryLocation()), this.val$monitor);
                                return false;
                            }
                            if (delta.getKind() == 1 && resource instanceof IContainer && !resource.isTeamPrivateMember() && FileUtility.isSVNInternals(resource)) {
                                FileUtility.findAndMarkSVNInternals(resource, true);
                                return false;
                            }
                            return true;
                        }
                    });
                }
            }, null, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ex) {
            LoggedOperation.reportError(this.getClass().getName(), ex);
        }
    }
}

