/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;

public interface IStateFilter {
    public static final String ST_NOTEXISTS = null;
    public static final String ST_NONE = "None";
    public static final String ST_NEW = "New";
    public static final String ST_ADDED = "Added";
    public static final String ST_NORMAL = "Normal";
    public static final String ST_MODIFIED = "Modified";
    public static final String ST_CONFLICTING = "Conflicting";
    public static final String ST_DELETED = "Deleted";
    public static final String ST_MISSING = "Missing";
    public static final String ST_OBSTRUCTED = "Obstructed";
    public static final String ST_PREREPLACED = "Prereplaced";
    public static final String ST_REPLACED = "Replaced";
    public static final String ST_LINKED = "Linked";
    public static final IStateFilter SF_EXTERNAL = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return (mask & 0x20) != 0;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return true;
        }
    };
    public static final IStateFilter SF_LINKED = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == IStateFilter.ST_LINKED;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return true;
        }
    };
    public static final IStateFilter SF_ALL = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return true;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return true;
        }
    };
    public static final IStateFilter SF_NOTEXISTS = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == ST_NOTEXISTS || state == IStateFilter.ST_LINKED;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return true;
        }
    };
    public static final IStateFilter SF_OBSTRUCTED = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == IStateFilter.ST_OBSTRUCTED;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return true;
        }
    };
    public static final IStateFilter SF_VALID = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state != IStateFilter.ST_OBSTRUCTED && state != IStateFilter.ST_LINKED;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return this.accept(resource, state, mask);
        }
    };
    public static final IStateFilter SF_REPLACED = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == IStateFilter.ST_REPLACED;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return SF_VERSIONED.accept(resource, state, mask);
        }
    };
    public static final IStateFilter SF_PREREPLACED = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == IStateFilter.ST_PREREPLACED;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return SF_VERSIONED.accept(resource, state, mask);
        }
    };
    public static final IStateFilter SF_PREREPLACEDREPLACED = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == IStateFilter.ST_PREREPLACED || state == IStateFilter.ST_REPLACED;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return SF_VERSIONED.accept(resource, state, mask);
        }
    };
    public static final IStateFilter SF_IGNORED = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == IStateFilter.ST_NONE;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return true;
        }
    };
    public static final IStateFilter SF_NONVERSIONED = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == IStateFilter.ST_PREREPLACED || state == IStateFilter.ST_NEW || state == IStateFilter.ST_NONE || state == ST_NOTEXISTS;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return true;
        }
    };
    public static final IStateFilter SF_VERSIONED = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == IStateFilter.ST_REPLACED || state == IStateFilter.ST_PREREPLACED || state == IStateFilter.ST_ADDED || state == IStateFilter.ST_NORMAL || state == IStateFilter.ST_MODIFIED || state == IStateFilter.ST_CONFLICTING || state == IStateFilter.ST_DELETED || state == IStateFilter.ST_MISSING;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return this.accept(resource, state, mask);
        }
    };
    public static final IStateFilter SF_NOTONREPOSITORY = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == IStateFilter.ST_PREREPLACED || state == IStateFilter.ST_NEW || state == IStateFilter.ST_NONE || state == ST_NOTEXISTS || state == IStateFilter.ST_ADDED;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return true;
        }
    };
    public static final IStateFilter SF_ONREPOSITORY = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == IStateFilter.ST_PREREPLACED || state == IStateFilter.ST_REPLACED || state == IStateFilter.ST_NORMAL || state == IStateFilter.ST_MODIFIED || state == IStateFilter.ST_CONFLICTING || state == IStateFilter.ST_DELETED || state == IStateFilter.ST_MISSING;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return SF_VERSIONED.accept(resource, state, mask);
        }
    };
    public static final IStateFilter SF_NEW = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == IStateFilter.ST_PREREPLACED || state == IStateFilter.ST_NEW;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return state != IStateFilter.ST_NONE && state != IStateFilter.ST_OBSTRUCTED && state != IStateFilter.ST_LINKED;
        }
    };
    public static final IStateFilter SF_ADDED = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == IStateFilter.ST_PREREPLACED || state == IStateFilter.ST_REPLACED || state == IStateFilter.ST_NEW || state == IStateFilter.ST_ADDED;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return SF_VERSIONED.accept(resource, state, mask);
        }
    };
    public static final IStateFilter SF_NOTMODIFIED = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == IStateFilter.ST_NORMAL || state == ST_NOTEXISTS || state == IStateFilter.ST_LINKED;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return true;
        }
    };
    public static final IStateFilter SF_MODIFIED = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == IStateFilter.ST_MODIFIED || state == IStateFilter.ST_CONFLICTING;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return SF_ONREPOSITORY.accept(resource, state, mask);
        }
    };
    public static final IStateFilter SF_CONFLICTING = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == IStateFilter.ST_CONFLICTING;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return SF_ONREPOSITORY.accept(resource, state, mask);
        }
    };
    public static final IStateFilter SF_DELETED = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == IStateFilter.ST_PREREPLACED || state == IStateFilter.ST_REPLACED || state == IStateFilter.ST_DELETED || state == IStateFilter.ST_MISSING;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return SF_ONREPOSITORY.accept(resource, state, mask);
        }
    };
    public static final IStateFilter SF_MISSING = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == IStateFilter.ST_MISSING;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return SF_ONREPOSITORY.accept(resource, state, mask);
        }
    };
    public static final IStateFilter SF_COMMITABLE = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == IStateFilter.ST_REPLACED || state == IStateFilter.ST_ADDED || state == IStateFilter.ST_MODIFIED || state == IStateFilter.ST_DELETED || state == IStateFilter.ST_MISSING;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return SF_VERSIONED.accept(resource, state, mask);
        }
    };
    public static final IStateFilter SF_REVERTABLE = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == IStateFilter.ST_PREREPLACED || state == IStateFilter.ST_CONFLICTING || state == IStateFilter.ST_REPLACED || state == IStateFilter.ST_ADDED || state == IStateFilter.ST_MODIFIED || state == IStateFilter.ST_DELETED || state == IStateFilter.ST_MISSING;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return SF_VERSIONED.accept(resource, state, mask);
        }
    };
    public static final IStateFilter SF_ANY_CHANGE = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state != IStateFilter.ST_NONE && state != IStateFilter.ST_NORMAL && state != IStateFilter.ST_OBSTRUCTED && state != IStateFilter.ST_LINKED;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return state != IStateFilter.ST_NONE && state != IStateFilter.ST_OBSTRUCTED && state != IStateFilter.ST_LINKED;
        }
    };
    public static final IStateFilter SF_EXCLUDE_DELETED = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            if (SF_ONREPOSITORY.accept(resource, state, mask)) {
                return state != IStateFilter.ST_DELETED && state != IStateFilter.ST_MISSING;
            }
            return false;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return this.accept(resource, state, mask);
        }
    };
    public static final IStateFilter SF_NEEDS_LOCK = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            if (!(resource instanceof IFile) || SF_NONVERSIONED.accept(resource, state, mask) || !resource.isAccessible()) {
                return false;
            }
            PropertyData[][] propData = new PropertyData[1][];
            AbstractNonLockingOperation op = new AbstractNonLockingOperation(this, "Operation.CheckProperty", resource, propData){
                final /* synthetic */ 26 this$1;
                private final /* synthetic */ IResource val$resource;
                private final /* synthetic */ PropertyData[][] val$propData;
                {
                    this.this$1 = var1_1;
                    this.val$resource = iResource;
                    this.val$propData = propertyDataArray;
                    super($anonymous0);
                }

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(this.val$resource);
                    ISVNClientWrapper proxy = location.acquireSVNProxy();
                    try {
                        this.val$propData[0] = proxy.properties(FileUtility.getWorkingCopyPath(this.val$resource), Revision.BASE, Revision.BASE, new SVNProgressMonitor(this, monitor, null));
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        location.releaseSVNProxy(proxy);
                        throw throwable;
                    }
                    {
                        Object var4_6 = null;
                        location.releaseSVNProxy(proxy);
                        return;
                    }
                }
            };
            ProgressMonitorUtility.doTaskExternalDefault(op, (IProgressMonitor)new NullProgressMonitor());
            boolean needsLock = false;
            if (propData[0] != null) {
                int i = 0;
                while (i < propData[0].length) {
                    if (propData[0][i].name.equals("svn:needs-lock")) {
                        needsLock = true;
                        break;
                    }
                    ++i;
                }
                return needsLock;
            }
            return false;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return SF_VERSIONED.accept(resource, state, mask);
        }
    };
    public static final IStateFilter SF_MODIFIED_NOT_IGNORED = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return !SF_IGNORED.accept(resource, state, mask) && !SF_NOTMODIFIED.accept(resource, state, mask);
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return state != IStateFilter.ST_NONE && state != IStateFilter.ST_OBSTRUCTED && state != IStateFilter.ST_LINKED;
        }
    };
    public static final IStateFilter SF_EXCLUDE_PREREPLACED_AND_DELETED = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            if (SF_VERSIONED.accept(resource, state, mask) && !SF_PREREPLACED.accept(resource, state, mask)) {
                return state != IStateFilter.ST_DELETED && state != IStateFilter.ST_MISSING;
            }
            return false;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return SF_EXCLUDE_DELETED.accept(resource, state, mask);
        }
    };
    public static final IStateFilter SF_EXCLUDE_PREREPLACED_AND_DELETED_FILES = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            if (resource instanceof IFile) {
                return SF_EXCLUDE_PREREPLACED_AND_DELETED.accept(resource, state, mask);
            }
            return false;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return SF_EXCLUDE_DELETED.accept(resource, state, mask);
        }
    };
    public static final IStateFilter SF_VERSIONED_FOLDERS = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            if (resource instanceof IContainer) {
                return SF_VERSIONED.accept(resource, state, mask);
            }
            return false;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return SF_VERSIONED.accept(resource, state, mask);
        }
    };

    public boolean accept(IResource var1, String var2, int var3);

    public boolean allowsRecursion(IResource var1, String var2, int var3);
}

