/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.client.javahl;

import java.text.MessageFormat;
import org.polarion.team.svn.client.javahl.JavaHLClientProxy;
import org.polarion.team.svn.client.javahl.JavaHLPlugin;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.extension.factory.ISVNClientWrapperFactory;
import org.polarion.team.svn.core.utility.FileUtility;
import org.tigris.subversion.javahl.SVNClient;

public class JavaHLClientWrapperFactory
implements ISVNClientWrapperFactory {
    public static final String CLIENT_ID = "org.polarion.team.svn.client.javahl";
    private static boolean librariesLoaded = false;

    public ISVNClientWrapper newInstance() {
        JavaHLClientWrapperFactory.checkLibraries();
        return new JavaHLClientProxy();
    }

    public String getName() {
        return JavaHLPlugin.instance().getResource("ClientName");
    }

    public String getId() {
        return CLIENT_ID;
    }

    public String getClientVersion() {
        try {
            JavaHLClientWrapperFactory.checkLibraries();
            return SVNClient.version();
        }
        catch (Throwable ex) {
            if (ex.getMessage() != null) {
                String errMessage = JavaHLPlugin.instance().getResource("Error.CannotLoadLibraries0");
                return MessageFormat.format(errMessage, ex.getMessage());
            }
            return JavaHLPlugin.instance().getResource("Error.CannotLoadLibraries1");
        }
    }

    public String getVersion() {
        return JavaHLPlugin.instance().getVersionString();
    }

    public String getCompatibilityVersion() {
        return "1.1.3";
    }

    public boolean isReportRevisionChangeAllowed() {
        return false;
    }

    public boolean isInteractiveMergeAllowed() {
        return true;
    }

    public boolean isAtomicCommitAllowed() {
        return false;
    }

    public boolean isCompareFoldersAllowed() {
        return false;
    }

    public boolean isFetchLocksAllowed() {
        return false;
    }

    public boolean isProxyOptionsAllowed() {
        return false;
    }

    public boolean isSSHOptionsAllowed() {
        return false;
    }

    public String toString() {
        return this.getId();
    }

    protected static void checkLibraries() {
        if (!librariesLoaded) {
            if (FileUtility.isWindows()) {
                System.loadLibrary("libdb44");
                System.loadLibrary("intl3_svn");
                System.loadLibrary("libapr");
                System.loadLibrary("libapriconv");
                System.loadLibrary("libaprutil");
                System.loadLibrary("libeay32");
                System.loadLibrary("ssleay32");
            }
            SVNClient.version();
            librariesLoaded = true;
        }
    }
}

