/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.client.javahl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.Path;
import org.polarion.team.svn.core.ICredentialsPrompt;
import org.polarion.team.svn.core.client.BlameCallback;
import org.polarion.team.svn.core.client.ChangePath;
import org.polarion.team.svn.core.client.ClientWrapperAuthenticationException;
import org.polarion.team.svn.core.client.ClientWrapperCancelException;
import org.polarion.team.svn.core.client.ClientWrapperException;
import org.polarion.team.svn.core.client.ClientWrapperUnresolvedConflictException;
import org.polarion.team.svn.core.client.DirEntry;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.ISVNProgressMonitor;
import org.polarion.team.svn.core.client.Info2;
import org.polarion.team.svn.core.client.LogMessage;
import org.polarion.team.svn.core.client.Notify2;
import org.polarion.team.svn.core.client.NotifyInformation;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.Notify2Composite;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.ConversionUtility;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.PromptUserPassword3;
import org.tigris.subversion.javahl.SVNClient;

public class JavaHLClientProxy
implements ISVNClientWrapper {
    protected SVNClient client = new SVNClient();
    protected ICredentialsPrompt prompt;
    protected Notify2Composite composite = new Notify2Composite();
    protected Notify2 installedNotify2;
    protected boolean commitMissingFiles;
    protected String sslCertificate;
    protected String sslPassphrase;

    public JavaHLClientProxy() {
        this.client.notification2(ConversionUtility.convert((Notify2)this.composite));
    }

    public String getConfigDirectory() throws ClientWrapperException {
        try {
            return this.client.getConfigDirectory();
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(String path, boolean recurse, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.add(path, recurse);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void blame(String path, Revision pegRevision, Revision revisionStart, Revision revisionEnd, BlameCallback callback, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.blame(path, ConversionUtility.convert(pegRevision), ConversionUtility.convert(revisionStart), ConversionUtility.convert(revisionEnd), ConversionUtility.convert(callback));
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long checkout(String moduleName, String destPath, Revision revision, Revision pegRevision, boolean recurse, boolean ignoreExternals, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            long l;
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                l = this.client.checkout(moduleName, destPath, ConversionUtility.convert(revision), ConversionUtility.convert(pegRevision), recurse, ignoreExternals);
                Object var10_10 = null;
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            return l;
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return 0L;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cleanup(String path, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.cleanup(path);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long[] commit(String[] path, String message, boolean recurse, boolean noUnlock, ISVNProgressMonitor monitor) throws ClientWrapperException {
        block20: {
            block19: {
                wrapper = new ProgressMonitorWrapper(monitor);
                try {
                    try {
                        block18: {
                            if (this.commitMissingFiles) {
                                i = 0;
                                while (i < path.length && !monitor.isActivityCancelled()) {
                                    if (!new File(path[i]).exists()) {
                                        this.client.remove(new String[]{path[i]}, null, true);
                                    }
                                    ++i;
                                }
                            }
                            if (!recurse) {
                                fullSet = new HashSet<String>(Arrays.asList(path));
                                deleted = new HashSet<String>();
                                FileUtility.sort((Object[])path);
                                i = 0;
                                while (true) {
                                    if (i >= path.length || monitor.isActivityCancelled()) {
                                        if (deleted.size() > 0) {
                                            if (fullSet.size() != 0) break;
                                            path = deleted.toArray(new String[deleted.size()]);
                                            recurse = true;
                                        }
                                        break block18;
                                    }
                                    toCheck = new File(path[i]);
                                    if (toCheck.isDirectory() && (st = this.client.status(path[i], false, false, false)) != null && st.length > 0) {
                                        j = 0;
                                        block7: while (j < st.length && !monitor.isActivityCancelled()) {
                                            if (st[j].getTextStatus() == 4 && st[j].getPath().length() == path[i].length()) {
                                                deleted.add(path[i]);
                                                root = path[i];
                                                while (i < path.length && !monitor.isActivityCancelled()) {
                                                    if (path[i].startsWith(root) && (path[i].length() == root.length() || path[i].charAt(root.length()) == '\\' || path[i].charAt(root.length()) == '/')) {
                                                        fullSet.remove(path[i]);
                                                        ++i;
                                                        continue;
                                                    }
                                                    --i;
                                                    break block7;
                                                }
                                                break;
                                            }
                                            ++j;
                                        }
                                    }
                                    ++i;
                                }
                                path = fullSet.toArray(new String[fullSet.size()]);
                                deletedPath = deleted.toArray(new String[deleted.size()]);
                                this.composite.add((Notify2)wrapper);
                                wrapper.start();
                                var16_17 = new long[]{this.client.commit(path, message, recurse, noUnlock), this.client.commit(deletedPath, message, true, noUnlock)};
                                var14_19 = null;
                                break block19;
                            }
                        }
                        this.composite.add((Notify2)wrapper);
                        wrapper.start();
                        var16_18 = new long[]{this.client.commit(path, message, recurse, noUnlock)};
                        break block20;
                    }
                    catch (ClientException ex) {
                        this.handleClientException(ex);
                        ** GOTO lbl-1000
                    }
                }
                catch (Throwable var15_23) {
                    var14_21 = null;
                    wrapper.interrupt();
                    this.composite.remove((Notify2)wrapper);
                    throw var15_23;
                }
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            return var16_17;
        }
        var14_20 = null;
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return var16_18;
lbl-1000:
        // 1 sources

        {
            var14_22 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copy(String srcPath, String destPath, String message, Revision revision, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.copy(srcPath, destPath, message, ConversionUtility.convert(revision));
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void diff(String target1, Revision revision1, Revision peg1, String target2, Revision revision2, Revision peg2, String outFileName, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean diffUnversioned, boolean relativePath, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            block6: {
                try {
                    this.composite.add((Notify2)wrapper);
                    wrapper.start();
                    if (this.usePegSignature(target1, revision1, peg1, target2, revision2, peg2)) {
                        this.client.diff(target1, ConversionUtility.convert(peg1), ConversionUtility.convert(revision1), ConversionUtility.convert(revision2), outFileName, recurse, ignoreAncestry, noDiffDeleted, force);
                        break block6;
                    }
                    this.client.diff(target1, ConversionUtility.convert(revision1), target2, ConversionUtility.convert(revision2), outFileName, recurse, ignoreAncestry, noDiffDeleted, force);
                }
                catch (ClientException ex) {
                    this.handleClientException(ex);
                }
            }
            Object var17_19 = null;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Status[] diffStatus(String url1, Revision pegRevision1, Revision revision1, String url2, Revision pegRevision2, Revision revision2, boolean recurse, boolean ignoreAncestry, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        File tmp = null;
        try {
            Status[] statusArray;
            block12: {
                try {
                    tmp = File.createTempFile("diffStatus", ".tmp");
                    this.composite.add((Notify2)wrapper);
                    wrapper.start();
                    if (this.usePegSignature(url1, revision1, pegRevision1, url2, revision2, pegRevision2)) {
                        this.client.diff(url1, ConversionUtility.convert(pegRevision1), ConversionUtility.convert(revision1), ConversionUtility.convert(revision2), tmp.getAbsolutePath(), recurse, ignoreAncestry, false, true);
                    } else {
                        this.client.diff(url1, ConversionUtility.convert(revision1), url2, ConversionUtility.convert(revision2), tmp.getAbsolutePath(), recurse, ignoreAncestry, false, true);
                    }
                    if (tmp.length() == 0L) {
                        Status[] statusArray2 = new Status[]{};
                        Object var13_14 = null;
                        if (tmp != null) {
                            tmp.delete();
                        }
                        wrapper.interrupt();
                        this.composite.remove((Notify2)wrapper);
                        return statusArray2;
                    }
                    statusArray = new Status[]{new Status(url1, url2, 1, -1L, -1L, 0L, null, 2, 1, 1, 1, false, false, null, null, null, null, -1L, false, null, null, null, 0L, null, -1L, 0L, 1, null, null)};
                    Object var13_15 = null;
                    if (tmp == null) break block12;
                    tmp.delete();
                }
                catch (IOException ex) {
                    throw new ClientWrapperException((Throwable)ex, false);
                }
                catch (ClientException ex) {
                    this.handleClientException(ex);
                }
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            return statusArray;
            Object var13_17 = null;
            if (tmp != null) {
                tmp.delete();
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (tmp != null) {
                tmp.delete();
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return null;
    }

    public void dispose() {
        this.client.dispose();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long doExport(String srcPath, String destPath, Revision revision, Revision pegRevision, boolean force, boolean ignoreExternals, boolean recurse, String nativeEOL, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            long l;
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                l = this.client.doExport(srcPath, destPath, ConversionUtility.convert(revision), ConversionUtility.convert(pegRevision), force, ignoreExternals, recurse, nativeEOL);
                Object var12_12 = null;
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            return l;
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return 0L;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doImport(String path, String url, String message, boolean recurse, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.doImport(path, url, message, recurse);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long doSwitch(String path, String url, Revision revision, boolean recurse, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            long l;
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                l = this.client.doSwitch(path, url, ConversionUtility.convert(revision), recurse);
                Object var8_8 = null;
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            return l;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] fileContent(String path, Revision revision, Revision pegRevision, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            byte[] byArray;
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                byArray = this.client.fileContent(path, ConversionUtility.convert(revision), ConversionUtility.convert(pegRevision));
                Object var7_7 = null;
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            return byArray;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void streamFileContent(String path, Revision revision, Revision pegRevision, int bufferSize, OutputStream stream, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.streamFileContent(path, ConversionUtility.convert(revision), ConversionUtility.convert(pegRevision), bufferSize, stream);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    public Notify2 getNotification2() {
        return this.installedNotify2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Info2[] info2(String pathOrUrl, Revision revision, Revision pegRevision, boolean recurse, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            Info2[] info2Array;
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                info2Array = ConversionUtility.convert(this.client.info2(pathOrUrl, ConversionUtility.convert(revision), ConversionUtility.convert(pegRevision), recurse));
                Object var8_8 = null;
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            return info2Array;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return null;
    }

    public boolean isCommitMissingFiles() {
        return this.commitMissingFiles;
    }

    public boolean isCredentialsCacheEnabled() {
        return true;
    }

    public boolean isReportRevisionChange() {
        return false;
    }

    public boolean isSSLCertificateCacheEnabled() {
        return true;
    }

    public boolean isTouchUnresolved() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DirEntry[] list(String url, Revision revision, Revision pegRevision, boolean recurse, boolean fetchLocks, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            DirEntry[] dirEntryArray;
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                org.tigris.subversion.javahl.DirEntry[] entries = this.client.list(url, ConversionUtility.convert(revision), ConversionUtility.convert(pegRevision), recurse);
                DirEntry[] retVal = new DirEntry[entries.length];
                int i = 0;
                while (true) {
                    if (i >= entries.length) {
                        dirEntryArray = retVal;
                        Object var11_13 = null;
                        break;
                    }
                    retVal[i] = new DirEntry(entries[i].getLastChanged(), entries[i].getLastChangedRevisionNumber(), entries[i].getHasProps(), entries[i].getLastAuthor(), entries[i].getNodeKind(), entries[i].getSize(), entries[i].getPath(), null);
                    ++i;
                }
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            return dirEntryArray;
            Object var11_15 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void lock(String[] path, String comment, boolean force, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.lock(path, comment, force);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LogMessage[] logMessages(String path, Revision pegRevision, Revision revisionStart, Revision revisionEnd, boolean stopOnCopy, boolean discoverPath, long limit, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            LogMessage[] logMessageArray;
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                logMessageArray = ConversionUtility.convert(this.client.logMessages(path, ConversionUtility.convert(revisionStart), ConversionUtility.convert(revisionEnd), stopOnCopy, discoverPath, limit));
                Object var12_11 = null;
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            return logMessageArray;
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void merge(String path, Revision pegRevision, Revision revision1, Revision revision2, String localPath, boolean force, boolean recurse, boolean ignoreAncestry, boolean dryRun, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.merge(path, ConversionUtility.convert(pegRevision), ConversionUtility.convert(revision1), ConversionUtility.convert(revision2), localPath, force, recurse, ignoreAncestry, dryRun);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void merge(String path1, Revision revision1, String path2, Revision revision2, String localPath, boolean force, boolean recurse, boolean ignoreAncestry, boolean dryRun, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.merge(path1, ConversionUtility.convert(revision1), path2, ConversionUtility.convert(revision2), localPath, force, recurse, ignoreAncestry, dryRun);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Status[] merge(String url, Revision peg, Revision from, Revision to, String mergePath, Status[] mergeStatus, boolean force, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                int i = 0;
                while (true) {
                    block14: {
                        block13: {
                            if (i >= mergeStatus.length) break block13;
                            if (!monitor.isActivityCancelled()) break block14;
                        }
                        Object var11_12 = null;
                        break;
                    }
                    if (mergeStatus[i].textStatus == 4) {
                        this.client.remove(new String[]{mergeStatus[i].path}, null, force);
                    } else if (mergeStatus[i].textStatus == 3 && !new File(mergeStatus[i].path).exists()) {
                        this.client.copy(mergeStatus[i].url, mergeStatus[i].path, null, ConversionUtility.convert(to));
                    } else {
                        this.client.merge(mergeStatus[i].url, ConversionUtility.convert(peg), ConversionUtility.convert(from), ConversionUtility.convert(to), mergeStatus[i].path, force, false, false, false);
                    }
                    ++i;
                }
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            return null;
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Status[] mergeStatus(String url, Revision peg, Revision from, Revision to, String path, Revision lastMerged, boolean recurse, boolean ignoreAncestry, ISVNProgressMonitor monitor) throws ClientWrapperException {
        final ArrayList tmp = new ArrayList();
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor){

            public void onNotify(NotifyInformation arg0) {
                super.onNotify(arg0);
                tmp.add(arg0);
            }
        };
        try {
            Status[] statusArray;
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.merge(url, ConversionUtility.convert(peg), ConversionUtility.convert(from), ConversionUtility.convert(to), path, true, recurse, ignoreAncestry, true);
                ArrayList<Status> retVal = new ArrayList<Status>();
                int i = 0;
                Iterator it = tmp.iterator();
                while (it.hasNext()) {
                    NotifyInformation state = (NotifyInformation)it.next();
                    String tUrl = SVNUtility.normalizeURL((String)(String.valueOf(url) + state.path.substring(path.length())));
                    int cState = 0;
                    int pState = 0;
                    if (state.action == 9) {
                        cState = 3;
                    } else if (state.action == 8) {
                        cState = 4;
                    } else if (state.action == 10) {
                        int n = pState = state.propState == 5 ? 2 : 0;
                        int n2 = state.contentState == 5 || state.contentState == 6 ? 2 : (cState = state.contentState == 7 || state.contentState == 8 ? 9 : 0);
                    }
                    if (cState != 0 || pState != 0) {
                        LogMessage[] msgs;
                        long revision = -1L;
                        long date = 0L;
                        String author = null;
                        String message = null;
                        if (cState != 4) {
                            msgs = this.logMessages(tUrl, peg, to, from, true, false, 1L, monitor);
                            if (msgs != null && msgs.length > 0) {
                                revision = msgs[0].revision;
                                date = msgs[0].date;
                                author = msgs[0].author;
                                message = msgs[0].message;
                            }
                        } else {
                            msgs = this.logMessages(new Path(tUrl).removeLastSegments(1).toString(), peg, to, from, true, true, 0L, monitor);
                            if (msgs != null) {
                                int j = 0;
                                while (j < msgs.length) {
                                    ChangePath[] paths = msgs[j].changedPaths;
                                    if (paths != null) {
                                        int k = 0;
                                        while (k < paths.length) {
                                            if (paths[k] != null && tUrl.endsWith(paths[k].path)) {
                                                revision = msgs[0].revision;
                                                date = msgs[0].date;
                                                author = msgs[0].author;
                                                message = msgs[0].message;
                                                j = msgs.length;
                                                break;
                                            }
                                            ++k;
                                        }
                                    }
                                    ++j;
                                }
                            }
                        }
                        retVal.add(new Status(state.path, tUrl, state.kind, revision, revision, date, author, cState, pState, 0, 0, false, false, null, null, null, null, -1L, false, null, null, message, 0L, null, -1L, 0L, state.kind, null, null));
                    }
                    ++i;
                }
                statusArray = retVal.toArray(new Status[retVal.size()]);
                Object var29_29 = null;
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            return statusArray;
            Object var29_31 = null;
        }
        catch (Throwable throwable) {
            Object var29_30 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mkdir(String[] path, String message, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.mkdir(path, message);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void move(String srcPath, String dstPath, boolean force, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.move(srcPath, dstPath, null, force);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void move(String srcPath, String destPath, String message, Revision revision, boolean force, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.move(srcPath, destPath, message, ConversionUtility.convert(revision), force);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    public void notification2(Notify2 notify) {
        if (this.installedNotify2 != null) {
            this.composite.remove(this.installedNotify2);
        }
        this.installedNotify2 = notify;
        if (this.installedNotify2 != null) {
            this.composite.add(this.installedNotify2);
        }
    }

    public void password(String password) {
        this.client.password(password == null ? "" : password);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PropertyData[] properties(String path, Revision revision, Revision peg, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            PropertyData[] propertyDataArray;
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                propertyDataArray = ConversionUtility.convert(this.client.properties(path, ConversionUtility.convert(revision), ConversionUtility.convert(peg)));
                Object var7_7 = null;
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            return propertyDataArray;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PropertyData propertyGet(String path, String name, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            PropertyData propertyData;
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                propertyData = ConversionUtility.convert(this.client.propertyGet(path, name));
                Object var6_6 = null;
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            return propertyData;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propertyRemove(String path, String name, boolean recurse, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.propertyRemove(path, name, recurse);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propertySet(String path, String name, byte[] value, boolean recurse, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.propertySet(path, name, value, recurse);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propertySet(String path, String name, String value, boolean recurse, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.propertySet(path, name, value, recurse);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolved(String path, boolean recurse, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.resolved(path, recurse);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void relocate(String from, String to, String path, boolean recurse, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.relocate(from, to, path, recurse);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(String[] path, String message, boolean force, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.remove(path, message, force);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void revert(String path, boolean recurse, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.revert(path, recurse);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    public void setClientSSLCertificate(String certPath, String passphrase) {
        this.sslCertificate = certPath == null || certPath.trim().length() == 0 ? null : certPath;
        this.sslPassphrase = passphrase;
    }

    public void setCommitMissingFiles(boolean commitMissingFiles) {
        this.commitMissingFiles = commitMissingFiles;
    }

    public void setCredentialsCacheEnabled(boolean cacheCredentials) {
    }

    public void setPrompt(ICredentialsPrompt prompt) {
        RepositoryInfoPrompt repositoryInfoPrompt;
        if (prompt == null) {
            repositoryInfoPrompt = null;
        } else {
            this.prompt = prompt;
            RepositoryInfoPrompt repositoryInfoPrompt2 = new RepositoryInfoPrompt(this.prompt);
            repositoryInfoPrompt = repositoryInfoPrompt2;
        }
        this.client.setPrompt((PromptUserPassword)repositoryInfoPrompt);
    }

    public ICredentialsPrompt getPrompt() {
        return this.prompt;
    }

    public void setProxy(String host, int port, String userName, String password) {
    }

    public void setReportRevisionChange(boolean report) {
    }

    public void setSSHCredentials(String userName, String privateKeyPath, String passphrase, int port) {
    }

    public void setSSHCredentials(String userName, String password, int port) {
    }

    public void setSSLCertificateCacheEnabled(boolean enabled) {
    }

    public void setTouchUnresolved(boolean touchUnresolved) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Status[] status(String path, boolean descend, boolean onServer, boolean getAll, boolean noIgnore, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            Status[] statusArray;
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                statusArray = ConversionUtility.convert(this.client.status(path, descend, onServer, getAll, noIgnore));
                Object var9_9 = null;
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            return statusArray;
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Status[] status(String path, boolean descend, boolean onServer, boolean getAll, boolean noIgnore, boolean collectParentExternals, boolean ignoreExternals, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            Status[] statusArray;
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                statusArray = ConversionUtility.convert(this.client.status(path, descend, onServer, getAll, noIgnore, ignoreExternals));
                Object var11_11 = null;
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            return statusArray;
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unlock(String[] path, boolean force, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.unlock(path, force);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long[] update(String[] path, Revision revision, boolean recurse, boolean ignoreExternals, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            long[] lArray;
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                lArray = this.client.update(path, ConversionUtility.convert(revision), recurse, ignoreExternals);
                Object var8_8 = null;
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            return lArray;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return null;
    }

    public void username(String username) {
        this.client.username(username == null ? "" : username);
    }

    protected void handleClientException(ClientException ex) throws ClientWrapperException {
        if (this.findConflict(ex)) {
            throw new ClientWrapperUnresolvedConflictException(ex.getMessage(), (Throwable)ex);
        }
        if (this.findCancel(ex)) {
            throw new ClientWrapperCancelException(ex.getMessage(), (Throwable)ex);
        }
        if (this.findAuthentication(ex)) {
            throw new ClientWrapperAuthenticationException(ex.getMessage(), (Throwable)ex);
        }
        throw new ClientWrapperException(ex.getMessage(), ex.getAprError(), (Throwable)ex, false);
    }

    protected boolean findConflict(ClientException t) {
        return t.getAprError() == 160024;
    }

    protected boolean findAuthentication(ClientException t) {
        return t.getAprError() == 170001;
    }

    protected boolean findCancel(ClientException t) {
        return t.getAprError() == 200015;
    }

    protected boolean usePegSignature(String target1, Revision revision1, Revision peg1, String target2, Revision revision2, Revision peg2) {
        int kind1 = revision1.getKind();
        int kind2 = revision2.getKind();
        if (!(kind1 != 5 && kind1 != 6 || kind2 != 5 && kind2 != 6)) {
            return false;
        }
        return target1.equals(target2) && (peg1 == peg2 || peg1 != null && peg1.equals((Object)peg2));
    }

    protected class ProgressMonitorWrapper
    extends Thread
    implements Notify2 {
        protected ISVNProgressMonitor monitor;
        protected int current;

        public ProgressMonitorWrapper(ISVNProgressMonitor monitor) {
            this.monitor = monitor;
            this.current = 0;
        }

        public void onNotify(NotifyInformation arg0) {
            this.monitor.progress(this.current++, -1, new ISVNProgressMonitor.ItemState(arg0.path, arg0.action, arg0.kind, arg0.mimeType, arg0.contentState, arg0.propState, arg0.lockState, arg0.revision));
        }

        public void run() {
            try {
                while (!this.monitor.isActivityCancelled() && !this.isInterrupted()) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {}
            if (this.monitor.isActivityCancelled()) {
                try {
                    JavaHLClientProxy.this.client.cancelOperation();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected class RepositoryInfoPrompt
    implements PromptUserPassword3 {
        protected ICredentialsPrompt prompt;

        public RepositoryInfoPrompt(ICredentialsPrompt prompt) {
            this.prompt = prompt;
        }

        public boolean prompt(String realm, String username) {
            return this.prompt.prompt(null, realm);
        }

        public boolean prompt(String realm, String username, boolean maySave) {
            return this.prompt.prompt(null, realm);
        }

        public int askTrustSSLServer(String info, boolean allowPermanently) {
            return this.prompt.askTrustSSLServer(null, info, allowPermanently);
        }

        public String getUsername() {
            return this.prompt.getUsername();
        }

        public String getPassword() {
            return this.prompt.getPassword();
        }

        public boolean askYesNo(String realm, String question, boolean yesIsDefault) {
            return false;
        }

        public String askQuestion(String realm, String question, boolean showAnswer, boolean maySave) {
            if (question.indexOf("certificate filename") != -1) {
                if (JavaHLClientProxy.this.sslCertificate != null) {
                    String retVal = JavaHLClientProxy.this.sslCertificate;
                    return retVal;
                }
                if (!this.prompt.promptSSL(null, realm)) {
                    return null;
                }
                JavaHLClientProxy.this.sslPassphrase = this.prompt.getSSLClientCertPassword();
                return this.prompt.getSSLClientCertPath();
            }
            if (question.indexOf("certificate passphrase") != -1) {
                if (JavaHLClientProxy.this.sslPassphrase != null) {
                    String retVal = JavaHLClientProxy.this.sslPassphrase;
                    return retVal;
                }
                if (!this.prompt.promptSSL(null, realm)) {
                    return null;
                }
                return this.prompt.getSSLClientCertPassword();
            }
            return null;
        }

        public String askQuestion(String realm, String question, boolean showAnswer) {
            return null;
        }

        public boolean userAllowedSave() {
            return this.prompt.isSaveCredentialsEnabled();
        }
    }
}

