/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.utilities;

import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.ac.ed.ph.snuggletex.SerializationSpecifier;
import uk.ac.ed.ph.snuggletex.internal.util.ConstraintUtilities;
import uk.ac.ed.ph.snuggletex.internal.util.XMLUtilities;
import uk.ac.ed.ph.snuggletex.utilities.SerializationOptions;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetManager;
import uk.ac.ed.ph.snuggletex.utilities.UnwrappedParallelMathMLDOM;

public final class MathMLUtilities {
    public static final String ANNOTATION_LOCAL_NAME = "annotation";
    public static final String ANNOTATION_XML_LOCAL_NAME = "annotation-xml";

    public static Document parseMathMLDocumentString(String mathmlDocument) throws IOException, SAXException {
        ConstraintUtilities.ensureNotNull(mathmlDocument, "mathmlDocument");
        return XMLUtilities.createNSAwareDocumentBuilder().parse(new InputSource(new StringReader(mathmlDocument)));
    }

    public static String serializeDocument(Document document2) {
        ConstraintUtilities.ensureNotNull(document2, "document");
        return MathMLUtilities.serializeNode(document2, "UTF-8", true, true);
    }

    public static String serializeDocument(Document document2, SerializationSpecifier serializationOptions) {
        ConstraintUtilities.ensureNotNull(document2, "document");
        return MathMLUtilities.serializeNode(document2, serializationOptions);
    }

    public static String serializeDocument(Document document2, SerializationSpecifier serializationOptions, StylesheetManager stylesheetManager) {
        ConstraintUtilities.ensureNotNull(stylesheetManager, "stylesheetManager");
        ConstraintUtilities.ensureNotNull(document2, "document");
        return MathMLUtilities.serializeNode(stylesheetManager, document2, serializationOptions);
    }

    public static String serializeDocument(Document document2, String encoding) {
        ConstraintUtilities.ensureNotNull(document2, "document");
        return MathMLUtilities.serializeNode(document2, encoding, true, true);
    }

    public static String serializeDocument(Document document2, String encoding, boolean indent) {
        ConstraintUtilities.ensureNotNull(document2, "document");
        return MathMLUtilities.serializeNode(document2, encoding, indent, true);
    }

    @Deprecated
    public static String serializeDocument(Document document2, boolean indent, boolean omitXMLDeclaration) {
        ConstraintUtilities.ensureNotNull(document2, "document");
        return MathMLUtilities.serializeNode(document2, null, indent, omitXMLDeclaration);
    }

    @Deprecated
    public static String serializeDocument(Document document2, String encoding, boolean indent, boolean omitXMLDeclaration) {
        ConstraintUtilities.ensureNotNull(document2, "document");
        return MathMLUtilities.serializeNode(document2, encoding, indent, omitXMLDeclaration);
    }

    public static String serializeElement(Element element) {
        ConstraintUtilities.ensureNotNull(element, "element");
        return MathMLUtilities.serializeNode(element, "UTF-8", true, true);
    }

    public static String serializeElement(Element element, SerializationSpecifier serializationOptions) {
        ConstraintUtilities.ensureNotNull(element, "element");
        return MathMLUtilities.serializeNode(element, serializationOptions);
    }

    public static String serializeElement(Element element, SerializationSpecifier serializationOptions, StylesheetManager stylesheetManager) {
        ConstraintUtilities.ensureNotNull(element, "element");
        ConstraintUtilities.ensureNotNull(stylesheetManager, "stylesheetManager");
        return MathMLUtilities.serializeNode(stylesheetManager, element, serializationOptions);
    }

    public static String serializeElement(Element element, String encoding) {
        ConstraintUtilities.ensureNotNull(element, "element");
        return MathMLUtilities.serializeNode(element, encoding, true, true);
    }

    public static String serializeElement(Element element, boolean indent) {
        ConstraintUtilities.ensureNotNull(element, "element");
        return MathMLUtilities.serializeNode(element, null, indent, true);
    }

    @Deprecated
    public static String serializeElement(Element element, boolean indent, boolean omitXMLDeclaration) {
        ConstraintUtilities.ensureNotNull(element, "element");
        return MathMLUtilities.serializeNode(element, null, indent, omitXMLDeclaration);
    }

    @Deprecated
    public static String serializeElement(Element element, String encoding, boolean indent, boolean omitXMLDeclaration) {
        ConstraintUtilities.ensureNotNull(element, "element");
        return MathMLUtilities.serializeNode(element, encoding, indent, omitXMLDeclaration);
    }

    public static String serializeElement(Element element, String encoding, boolean indent) {
        ConstraintUtilities.ensureNotNull(element, "element");
        return MathMLUtilities.serializeNode(element, encoding, indent, true);
    }

    private static String serializeNode(Node node, SerializationSpecifier serializationOptions) {
        return XMLUtilities.serializeNode(node, serializationOptions);
    }

    private static String serializeNode(Node node, String encoding, boolean indent, boolean omitXMLDeclaration) {
        SerializationOptions serializationOptions = new SerializationOptions();
        serializationOptions.setEncoding(encoding != null ? encoding : "UTF-8");
        serializationOptions.setIndenting(indent);
        serializationOptions.setIncludingXMLDeclaration(!omitXMLDeclaration);
        return XMLUtilities.serializeNode(node, serializationOptions);
    }

    private static String serializeNode(StylesheetManager stylesheetManager, Node node, SerializationSpecifier serializationOptions) {
        return XMLUtilities.serializeNode(stylesheetManager, node, serializationOptions);
    }

    public static boolean isMathMLElement(Node node) {
        return MathMLUtilities.isMathMLElement(node, null);
    }

    public static boolean isMathMLElement(Node node, String localName) {
        ConstraintUtilities.ensureNotNull(node, "Node");
        return node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.w3.org/1998/Math/MathML") && (localName == null || localName.equals(node.getLocalName()));
    }

    public static void ensureMathMLContainer(Element mathElement) {
        if (!MathMLUtilities.isMathMLElement(mathElement, "math")) {
            throw new IllegalArgumentException("Not a MathML <math/> element");
        }
    }

    public static Element ensureMathMLDocument(Document document2) {
        Element result2 = document2.getDocumentElement();
        if (result2 == null) {
            throw new IllegalArgumentException("Document does not have a document element");
        }
        MathMLUtilities.ensureMathMLContainer(result2);
        return result2;
    }

    public static UnwrappedParallelMathMLDOM unwrapParallelMathMLDOM(Element mathElement) {
        MathMLUtilities.ensureMathMLContainer(mathElement);
        Node search = mathElement.getFirstChild();
        if (search == null || !MathMLUtilities.isMathMLElement(search, "semantics")) {
            return null;
        }
        UnwrappedParallelMathMLDOM result2 = new UnwrappedParallelMathMLDOM();
        result2.setMathElement(mathElement);
        Element semantics = (Element)search;
        NodeList childNodes = semantics.getChildNodes();
        if (childNodes.getLength() == 0) {
            return null;
        }
        result2.setFirstBranch((Element)childNodes.item(0));
        int i = 1;
        int length = childNodes.getLength();
        while (i < length) {
            search = childNodes.item(i);
            if (MathMLUtilities.isMathMLElement(search)) {
                Element searchElement = (Element)search;
                if (ANNOTATION_LOCAL_NAME.equals(search.getLocalName())) {
                    result2.getTextAnnotations().put(searchElement.getAttribute("encoding"), XMLUtilities.extractTextElementValue(searchElement));
                } else if (ANNOTATION_XML_LOCAL_NAME.equals(search.getLocalName())) {
                    result2.getXmlAnnotations().put(searchElement.getAttribute("encoding"), searchElement.getChildNodes());
                }
            }
            ++i;
        }
        return result2;
    }

    public static Element extractFirstSemanticsBranch(Element mathElement) {
        MathMLUtilities.ensureMathMLContainer(mathElement);
        Node search = mathElement.getFirstChild();
        if (search == null || !MathMLUtilities.isMathMLElement(search, "semantics")) {
            return null;
        }
        Element semantics = (Element)search;
        NodeList childNodes = semantics.getChildNodes();
        return childNodes.getLength() == 0 ? null : (Element)childNodes.item(0);
    }

    public static String extractAnnotationString(Element mathElement, String encodingAttribute) {
        Element annotationElement = MathMLUtilities.extractAnnotationElement(mathElement, ANNOTATION_LOCAL_NAME, encodingAttribute);
        return annotationElement != null ? XMLUtilities.extractTextElementValue(annotationElement) : null;
    }

    public static NodeList extractAnnotationXML(Element mathElement, String encodingAttribute) {
        Element annotationElement = MathMLUtilities.extractAnnotationElement(mathElement, ANNOTATION_XML_LOCAL_NAME, encodingAttribute);
        return annotationElement != null ? annotationElement.getChildNodes() : null;
    }

    private static Element extractAnnotationElement(Element mathmlElement, String annotationElementLocalName, String encodingAttribute) {
        MathMLUtilities.ensureMathMLContainer(mathmlElement);
        ConstraintUtilities.ensureNotNull(encodingAttribute, "encoding");
        Node search = mathmlElement.getFirstChild();
        if (search == null || !MathMLUtilities.isMathMLElement(search, "semantics")) {
            return null;
        }
        Element semantics = (Element)search;
        NodeList childNodes = semantics.getChildNodes();
        int i = 0;
        int length = childNodes.getLength();
        while (i < length) {
            search = childNodes.item(i);
            if (MathMLUtilities.isMathMLElement(search, annotationElementLocalName) && encodingAttribute.equals(((Element)search).getAttribute("encoding"))) {
                return (Element)search;
            }
            ++i;
        }
        return null;
    }

    public static Document isolateFirstSemanticsBranch(Element mathElement) {
        Element firstSemantics = MathMLUtilities.extractFirstSemanticsBranch(mathElement);
        return firstSemantics != null ? MathMLUtilities.isolateDescendant(mathElement, firstSemantics) : null;
    }

    public static Document isolateFirstSemanticsBranch(UnwrappedParallelMathMLDOM unwrappedDOM) {
        ConstraintUtilities.ensureNotNull(unwrappedDOM, "UnwrappedParallelMathMLDOM");
        Element firstSemantics = unwrappedDOM.getFirstBranch();
        return firstSemantics != null ? MathMLUtilities.isolateDescendant(unwrappedDOM.getMathElement(), firstSemantics) : null;
    }

    public static Document isolateAnnotationXML(Element mathElement, String encodingAttribute) {
        NodeList annotationContents = MathMLUtilities.extractAnnotationXML(mathElement, encodingAttribute);
        return annotationContents != null ? MathMLUtilities.isolateDescendant(mathElement, annotationContents) : null;
    }

    public static Document isolateAnnotationXML(UnwrappedParallelMathMLDOM unwrappedDOM, String encodingAttribute) {
        ConstraintUtilities.ensureNotNull(unwrappedDOM, "UnwrappedParallelMathMLDOM");
        NodeList annotationContents = unwrappedDOM.getXmlAnnotations().get(encodingAttribute);
        return annotationContents != null ? MathMLUtilities.isolateDescendant(unwrappedDOM.getMathElement(), annotationContents) : null;
    }

    private static Document isolateDescendant(Element mathElement, NodeList descendants) {
        Document result2 = XMLUtilities.createNSAwareDocumentBuilder().newDocument();
        Element resultMathElement = (Element)mathElement.cloneNode(false);
        result2.adoptNode(resultMathElement);
        result2.appendChild(resultMathElement);
        int i = 0;
        int size2 = descendants.getLength();
        while (i < size2) {
            Node annotationNode = descendants.item(i);
            Node annotationNodeCopy = annotationNode.cloneNode(true);
            result2.adoptNode(annotationNodeCopy);
            resultMathElement.appendChild(annotationNodeCopy);
            ++i;
        }
        return result2;
    }

    private static Document isolateDescendant(Element mathElement, Element descendant2) {
        Document result2 = XMLUtilities.createNSAwareDocumentBuilder().newDocument();
        Element resultMathElement = (Element)mathElement.cloneNode(false);
        result2.adoptNode(resultMathElement);
        result2.appendChild(resultMathElement);
        Element firstSemanticElementCopy = (Element)descendant2.cloneNode(true);
        result2.adoptNode(firstSemanticElementCopy);
        resultMathElement.appendChild(firstSemanticElementCopy);
        return result2;
    }
}

