/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.tokens;

import java.util.EnumMap;
import uk.ac.ed.ph.snuggletex.SnugglePackage;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinCommand;
import uk.ac.ed.ph.snuggletex.definitions.LaTeXMode;
import uk.ac.ed.ph.snuggletex.internal.FrozenSlice;
import uk.ac.ed.ph.snuggletex.internal.util.DumpMode;
import uk.ac.ed.ph.snuggletex.internal.util.ObjectDumperOptions;
import uk.ac.ed.ph.snuggletex.internal.util.ObjectUtilities;
import uk.ac.ed.ph.snuggletex.semantics.Interpretation;
import uk.ac.ed.ph.snuggletex.semantics.InterpretationType;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.TokenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Token {
    protected final FrozenSlice slice;
    protected final TokenType type;
    protected final LaTeXMode latexMode;
    protected final EnumMap<InterpretationType, Interpretation> interpretationMap;

    protected Token(FrozenSlice slice2, TokenType type, LaTeXMode latexMode, Interpretation ... interpretations) {
        this.slice = slice2;
        this.type = type;
        this.latexMode = latexMode;
        this.interpretationMap = SnugglePackage.makeInterpretationMap(interpretations);
    }

    protected Token(FrozenSlice slice2, TokenType type, LaTeXMode latexMode, EnumMap<InterpretationType, Interpretation> interpretationMap) {
        this.slice = slice2;
        this.type = type;
        this.latexMode = latexMode;
        this.interpretationMap = interpretationMap;
    }

    @ObjectDumperOptions(value=DumpMode.TO_STRING)
    public FrozenSlice getSlice() {
        return this.slice;
    }

    public TokenType getType() {
        return this.type;
    }

    public LaTeXMode getLatexMode() {
        return this.latexMode;
    }

    @ObjectDumperOptions(value=DumpMode.TO_STRING)
    public EnumMap<InterpretationType, Interpretation> getInterpretationMap() {
        return this.interpretationMap;
    }

    public Interpretation getInterpretation(InterpretationType type) {
        return this.interpretationMap != null ? this.interpretationMap.get((Object)type) : null;
    }

    public boolean hasInterpretationType(InterpretationType ... types) {
        if (this.interpretationMap == null) {
            return false;
        }
        InterpretationType[] interpretationTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            InterpretationType testType = interpretationTypeArray[n2];
            if (this.interpretationMap.containsKey((Object)testType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isCommand(BuiltinCommand command) {
        return this instanceof CommandToken && ((CommandToken)this).getCommand() == command;
    }

    public String toString() {
        return ObjectUtilities.beanToString(this);
    }
}

