/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.tokens;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import uk.ac.ed.ph.snuggletex.definitions.LaTeXMode;
import uk.ac.ed.ph.snuggletex.internal.FrozenSlice;
import uk.ac.ed.ph.snuggletex.internal.util.DumpMode;
import uk.ac.ed.ph.snuggletex.internal.util.ObjectDumperOptions;
import uk.ac.ed.ph.snuggletex.semantics.Interpretation;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;
import uk.ac.ed.ph.snuggletex.tokens.Token;
import uk.ac.ed.ph.snuggletex.tokens.TokenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ObjectDumperOptions(value=DumpMode.DEEP)
public final class ArgumentContainerToken
extends Token
implements Iterable<FlowToken> {
    public static final ArgumentContainerToken[] EMPTY_ARRAY = new ArgumentContainerToken[0];
    private final List<FlowToken> contents;

    public ArgumentContainerToken(FrozenSlice slice2, LaTeXMode latexMode, List<FlowToken> contents) {
        super(slice2, TokenType.ARGUMENT_CONTAINER, latexMode, new Interpretation[0]);
        this.contents = contents;
    }

    public static ArgumentContainerToken createFromSingleToken(LaTeXMode latexMode, FlowToken content) {
        ArrayList<FlowToken> contentList = new ArrayList<FlowToken>();
        contentList.add(content);
        return new ArgumentContainerToken(content.getSlice(), latexMode, contentList);
    }

    public static ArgumentContainerToken createFromContiguousTokens(Token parentToken, LaTeXMode latexMode, List<? extends FlowToken> contents) {
        return ArgumentContainerToken.createFromContiguousTokens(parentToken, latexMode, contents, 0, contents.size());
    }

    public static ArgumentContainerToken createFromContiguousTokens(Token parentToken, LaTeXMode latexMode, List<? extends FlowToken> contents, int startIndex, int endIndex) {
        ArgumentContainerToken result2;
        if (startIndex > endIndex) {
            throw new IllegalArgumentException("startIndex must be <= endIndex");
        }
        if (contents.size() > 0) {
            FrozenSlice startSlice = contents.get(startIndex).getSlice();
            FrozenSlice endSlice = contents.get(endIndex - 1).getSlice();
            FrozenSlice resultSlice = startSlice.rightOuterSpan(endSlice);
            result2 = new ArgumentContainerToken(resultSlice, latexMode, new ArrayList<FlowToken>(contents.subList(startIndex, endIndex)));
        } else {
            result2 = ArgumentContainerToken.createEmptyContainer(parentToken, latexMode);
        }
        return result2;
    }

    public static ArgumentContainerToken createEmptyContainer(Token parentToken, LaTeXMode latexMode) {
        List<FlowToken> emptyTokens = Collections.emptyList();
        return new ArgumentContainerToken(parentToken.getSlice(), latexMode, emptyTokens);
    }

    @ObjectDumperOptions(value=DumpMode.DEEP)
    public List<FlowToken> getContents() {
        return this.contents;
    }

    @Override
    public Iterator<FlowToken> iterator() {
        return this.contents.iterator();
    }
}

