/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.dombuilding;

import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.definitions.TextFlowContext;
import uk.ac.ed.ph.snuggletex.dombuilding.CommandHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.EnvironmentHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.semantics.InterpretationType;
import uk.ac.ed.ph.snuggletex.semantics.StyleDeclarationInterpretation;
import uk.ac.ed.ph.snuggletex.tokens.ArgumentContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;

public final class StyleInterpretationHandler
implements CommandHandler,
EnvironmentHandler {
    public void handleCommand(DOMBuilder builder, Element parentElement, CommandToken token2) throws SnuggleParseException {
        StyleDeclarationInterpretation styleInterpretation = (StyleDeclarationInterpretation)token2.getCommand().getInterpretation(InterpretationType.STYLE_DECLARATION);
        this.handleContent(builder, parentElement, styleInterpretation, token2.getArguments()[0]);
    }

    public void handleEnvironment(DOMBuilder builder, Element parentElement, EnvironmentToken token2) throws SnuggleParseException {
        StyleDeclarationInterpretation styleInterpretation = (StyleDeclarationInterpretation)token2.getEnvironment().getInterpretation(InterpretationType.STYLE_DECLARATION);
        this.handleContent(builder, parentElement, styleInterpretation, token2.getContent());
    }

    public void handleContent(DOMBuilder builder, Element parentElement, StyleDeclarationInterpretation interpretation, ArgumentContainerToken contentContainerToken) throws SnuggleParseException {
        Element result2 = parentElement;
        if (builder.isBuildingMathMLIsland()) {
            String mathVariant = interpretation.getTargetMathMLMathVariantName();
            if (mathVariant != null && !contentContainerToken.getContents().isEmpty()) {
                result2 = builder.appendMathMLElement(parentElement, "mstyle");
                result2.setAttribute("mathvariant", mathVariant);
            } else {
                result2 = builder.appendMathMLElement(parentElement, "mrow");
            }
        } else {
            boolean hasBlockContent = false;
            for (FlowToken contentToken : contentContainerToken) {
                if (contentToken.getTextFlowContext() != TextFlowContext.START_NEW_XHTML_BLOCK) continue;
                hasBlockContent = true;
            }
            if (hasBlockContent && interpretation.getTargetBlockXHTMLElementName() != null) {
                result2 = builder.appendXHTMLElement(parentElement, interpretation.getTargetBlockXHTMLElementName());
                if (interpretation.getTargetBlockCSSClassName() != null) {
                    builder.applyCSSStyle(result2, interpretation.getTargetBlockCSSClassName());
                }
            } else if (!hasBlockContent && interpretation.getTargetInlineXHTMLElementName() != null) {
                result2 = builder.appendXHTMLElement(parentElement, interpretation.getTargetInlineXHTMLElementName());
                if (interpretation.getTargetInlineCSSClassName() != null) {
                    builder.applyCSSStyle(result2, interpretation.getTargetInlineCSSClassName());
                }
            }
        }
        builder.handleTokens(result2, contentContainerToken, false);
    }
}

