//
//	base.js
//
//		1. This source code is MIT licence.
//		2. Copyright(C) All rights 2012 blueskis
//		3. If you find bugs that I have to fix , Please send mail blueskis382 @ gmail.com
//
//		1. このソースコードはMIT licenceとして配布します。
//		3. もしバグを見つけたら、 blueskis382 @ gmail.com にメールを送っていただけたらうれしいです。
//

var Invariant = new Array() ;	//定数
Invariant["APP_NAME"] = "BIEditor" ;

var util = {	//ユーティリティ関数
	SupportedChecker : function(){	//サポートされているかのチェック
		var str = "" ;
		if(!window.File) str += "・ファイルを開く/保存する機能、画像を表示する機能\n" ;
		if(!str == "") alert("このWebブラウザでは以下の機能が利用できません。\n" + str) ;
	} ,
	TransmissionMIMETypeForCodeMirror : function(filePath){ 	//拡張子からCodeMirror用のMIME Typeに設定
		var querys = [
			[".php" , "application/x-httpd-php"] ,
			[".pl" , "text/x-perl"] ,
			[".html" , "text/html"] ,
			[".xml" , "text/xml"] ,
			[".css" , "text/css"] ,
			[".xml" , "application/xml"] ,
			[".xul" , "application/xml"] ,
			[".rss" , "application/xml"] ,
			[".js" , "text/javascript"] ,
			[".jse" , "text/javascript"] ,
			[".vbs" , "text/vbscript"] ,
			[".vb" , "text/vb"] ,
			[".c" , "text/x-csrc"] ,
			[".cpp" , "text/x-c++src"] ,
			[".cshape" , "text/x-csharp"] ,
			[".java" ,  "text/x-java"] ,
			[".coffee" , "text/x-coffeescript"] ,
			[".sql" , "text/x-mysql"] ,
			[".py" , "text/x-python"] ,
			[".rb" , "text/x-ruby"] ,
			[".less" , "text/x-less"] ,
			[".diff" , "text/x-diff"] ,
			[".json" , "application/json"] ,
			[".ini" , "text/x-ini"] ,
			[".sh" , "text/x-sh"] ,
			[".bash" , "text/x-sh"] ,
			[".go" , "text/x-go"] ,
			[".clj" , "text/x-clojure"] ,
			[".lisp" , "text/x-ecl"] ,
			[".hs" , "text/x-haskell"] ,
			[".hx" , "text/x-haxe"] ,
			[".lua" , "text/x-lua"] ,
			[".md" , "text/x-markdown"] ,
			[".markdown" , "text/markdown"] ,
			[".mkd" , "text/markdown"] ,
			[".mdown" , "text/markdown"] ,
			[".mkdn" , "text/markdown"] ,
			[".mark" , "text/markdown"] ,
			[".sql" , "text/x-mysql"] ,
			[".r" , "text/x-rsrc"] ,
			[".s" , "text/x-rsrc"] ,
			[".rs" , "text/x-rustsrc"] ,
			[".scm" , "text/x-scheme"] ,
			[".st" , "text/x-stsrc"] ,
			[".tpl" , "text/x-smarty"] ,
			[".srx" , "application/x-sparql-query"] ,
			[".latex" , "text/x-stex"] ,
			[".tex" , "text/x-stex"] ,
			[".vm" , "text/velocity"] ,
			[".v" , "text/x-verilog"] ,
			[".xquery" , "application/xquery"] 
		] ;
		for(var i=0;i<querys.length;i++){
			if(filePath.indexOf(querys[i][0]) != -1)
				return querys[i][1] ;
		}
		return "text/plain" ;
	} ,
	getFileFullPath : function(element){	//ファイルのフルパスを取得(※Chromeでは<input type="file">のvalueがC:\fakepath\みたいになるから
		if(window.File){
			return element.files[0].name
		}else{
			return element.value ; //For IE
		}
	} ,
	File : function(elem , encode){	//クロスブラウザ対応ファイルオブジェクト

		//IEのFileSystemObjectって、UTF-16かShift-JISしか対応していない
		if(window.ActiveXObject && encode != "utf-16" && encode != "shift-jis"){
			throw new Exception.File.UnavaiableFileEncodingException() ;
		}
		
		this.elem = elem ;
		this.encode = encode ;	
		
		this.read = function(loadedFunc){	//ファイル読み込み	(loadedFunc : ファイル読み込み後に実行する関数)
			if(window.File){	//File API (Firefox , Google Chrome , IE10)
				var reader = new FileReader() ;
				reader.onload = function(event){
					loadedFunc(event.target.result) ;
				} ;
				reader.readAsText(this.elem.files[0] , this.encode) ;

			}else if(window.opera){	//Opera
				//いまのところ未対応。Operaには。
				throw new Exception.File.UnSupportedFileReading() ;
			}else if(window.ActiveXObject){	//IE系
				try{
					var isUnicode = true ;
					if(this.encode == "shift-jis") isUnicode = false ;
					
					var stream = new ActiveXObject("FileSystemObject").OpenTextFile(this.elem.value , 2 , isUnicode) ;
					loadedFunc(stream.ReadAll()) ;
					
				}catch(e){
					alert("エラー : " + e) ;
				}
			}else{
				throw new Exception.File.UnSupportedFileReading() ;
			}
		}
		this.write = function(str){
			//未実装
		}
	} ,
	CopyToClipboard : function(text){
		var input, success;
		if ("console" in window && "notifyFirebug" in console) {
			console.notifyFirebug([text], "copy", "firebugExecuteCommand");
			success = true;
		} else {
			input = document.createElement("input");
			input.style.display = "none" ;
			input.value = text;
			document.body.appendChild(input);
			input.select();
			try {
				success = document.execCommand("copy", false, null);
			} catch (ex) {
				success = false;
			} finally {
				document.body.removeChild(input);
			}
		}
		if (!success) {
			alert("お使いのWebブラウザではこの操作はサポートされていません。") ;
		}
	}
}

var Exception = {	//例外用オブジェクト
	File : {	//ファイル系エラー
		UnavaiableFileEncodingException : function(){	//ファイルのエンコードが利用不可
			this.message = "このWebブラウザでサポートされていないエンコードの指定です" ;
			this.className = "UnavaiableFileEncodingException" ;
		} ,
		UnSupportedFileReading : function(){	//ファイル読み込みがサポートされていない
			this.message = "このWebブラウザではファイルの読み込みができません" ;
			this.className = "UnSupportedFileReading" ;
		}
	}
}

var Sys = {	//テキストエディタのシステムに関わる関数
	initSettingItem : function(){	//設定項目の初期化
		if(Sys.storage.get("TextEditor.ThemeSelector")){
			$("#theme-selector").val(Sys.storage.get("TextEditor.ThemeSelector")) ;
			$("#keyMap").val(Sys.storage.get("TextEditor.keyMap")) ;
			$("#background_image_src").val(Sys.storage.get("TextEditor.BackGroundImageSource")) ;
			$("#background_opacity").val(Sys.storage.get("TextEditor.BackGroundImageOpacity")) ;
			$("#TabSize").val(Sys.storage.get("TextEditor.TabSize")) ;
			
			if(Sys.storage.get("TextEditor.LineNumberShow") == "true")
				$("#lineNumbers")[0].checked = true ;
			else
				$("#lineNumbers")[0].checked = false ;
			
			$("#background_image").attr("src" , Sys.storage.get("TextEditor.BackGroundImageSource")) 
								.css("opacity" , Sys.storage.get("TextEditor.BackGroundImageOpacity")) ;
		}
		Sys.outputStorageData() ;
	} ,
	outputStorageData : function(){	//設定項目のストレージデータの読み込み
		var str = "" ;
		var cnt = 0 ;
		for(var s in Sys.storage.getAll()){
			if(s.indexOf("TextEditor") != -1){
				str +=  "<tr><td>" + s + "</td><td><input type=\"text\" value=\"" + Sys.storage.get(s) + "\"></td></tr>" ;
			}
			cnt++ ;
		}
		$("#storage_result").html(str) ;
		
	} ,
	initCommonEditor : function(){	//メインのエディタの初期化
		var hlLine = null　, hlLine2 = null ;
		Sys.commonEditor = CodeMirror.fromTextArea(document.getElementById("editor"), {
			lineNumbers: (Sys.storage.get("TextEditor.LineNumberShow") ? Sys.storage.get("TextEditor.LineNumberShow") : true) ,
			tabSize: (Sys.storage.get("TextEditor.TabSize") ? Sys.storage.get("TextEditor.TabSize") : 4) ,
			indentUnit: 4,
			indentWithTabs: true ,
			theme : (Sys.storage.get("TextEditor.ThemeSelector") ? Sys.storage.get("TextEditor.ThemeSelector") : "eclipse") ,
			onCursorActivity: function() {
				Sys.commonEditor.setLineClass(hlLine, null, null);
				hlLine = Sys.commonEditor.setLineClass(Sys.commonEditor.getCursor().line, null, "activeline");
			} ,
			onGutterClick: function(cm, n) {
				var info = cm.lineInfo(n);
				if (info.markerText)
					cm.clearMarker(n);
				else
					cm.setMarker(n, "<span style=\"color: #900\">●</span> %N%");
			} ,
			mode: "text/plain" ,
			profile : "html" ,
			keyMap : (Sys.storage.get("TextEditor.KeyMap") ? Sys.storage.get("TextEditor.KeyMap") : "default")
		});
		Sys.commonEditor.setValue("") ;
		hlLine = Sys.commonEditor.setLineClass(0, "activeline");
		
		Sys.beginEditor = CodeMirror.fromTextArea(document.getElementById("stating-js-code"), {
			lineNumbers: (Sys.storage.get("TextEditor.LineNumberShow") ? Sys.storage.get("TextEditor.LineNumberShow") : true) ,
			tabSize: (Sys.storage.get("TextEditor.TabSize") ? Sys.storage.get("TextEditor.TabSize") : 4) ,
			indentUnit: 4,
			indentWithTabs: true ,
			theme : (Sys.storage.get("TextEditor.ThemeSelector") ? Sys.storage.get("TextEditor.ThemeSelector") : "eclipse") ,
			onCursorActivity: function() {
				Sys.commonEditor.setLineClass(hlLine2, null, null);
				hlLine2 = Sys.commonEditor.setLineClass(Sys.commonEditor.getCursor().line, null, "activeline");
			} ,
			onGutterClick: function(cm, n) {
				var info = cm.lineInfo(n);
				if (info.markerText)
					cm.clearMarker(n);
				else
					cm.setMarker(n, "<span style=\"color: #900\">●</span> %N%");
			} ,
			mode: "text/javascript" ,
			keyMap : (Sys.storage.get("TextEditor.KeyMap") ? Sys.storage.get("TextEditor.KeyMap") : "default")
		});
		Sys.beginEditor.setValue(
			(Sys.storage.get("TextEditor.BeginScript") ? Sys.storage.get("TextEditor.BeginScript") : "//起動時に実行されるスクリプト(JavaScript)を書いてください")
		) ;
		hlLine2 = Sys.beginEditor.setLineClass(0 , "activeline") ;
	} ,
	initClickedWork : function(){	//クリックされた時の動作の初期化
			$('[data-action="Open"]').click(function(){
				$("#Open").dialog("open") ;
			}) ;
			$('[data-action="ReOpen"]').click(function(){
				var file = new File(currentFile) ;
				file.read(function(s){
					Sys.commonEditor.setValue(s) ;
				}) ;
			}) ;
			$('[data-action="About"]').click(function(){
				$("#About").dialog("open") ;
			}) ;
			$('[data-action="Save"]').click(function(){
				var blobBuilder;
				if ("MozBlobBuilder" in window) {
					blobBuilder = new MozBlobBuilder();
				} else if ("WebKitBlobBuilder" in window) {
					blobBuilder = new WebKitBlobBuilder();
				}

				blobBuilder.append(Sys.commonEditor.getValue());
			
				if (window.URL) 
					window.open( window.URL.createObjectURL(blobBuilder.getBlob()) ) ;
				else if (window.webkitURL)
					window.open(window.webkitURL.createObjectURL(blobBuilder.getBlob()) );

			}) ;
			$('[data-action="SaveAs"]').click(function(){
			}) ;
			$('[data-action="Print"]').click(function(){
				window.scroll(0 , 0) ;
				window.print() ;
				
			}) ;
			$('[data-action="Exit"]').click(function(){
				window.close() ;
			}) ;
			$('[data-action="Undo"]').click(Sys.commonEditor.undo)
			$('[data-action="Redo"]').click(Sys.commonEditor.redo)
			$('[data-action="Copy"]').click(function(){
				util.CopyToClipboard(editor.getSelection) ;
			}) ;
			$('[data-action="Paste"]').click(function(){
				document.execCommand("paste") ;
			}) ;
			$('[data-action="Delete"]').click(function(){
				document.execCommand("delete") ;
			}) ;
			$('[data-action="SelectAll"]').click(function(){
				document.execCommand("selectAll") ;
			}) ;
			$('[data-action="SettingEnvironment"]').click(function(){
				$("#SettingEnvironment").dialog("open") ;
			}) ;
			$('[data-action="Search"]').click(function(){
				$("#searchbox").dialog("open") ;
			}) ;
			$('[data-action="Replace"]').click(function(){
				$("#replacebox").dialog("open") ;
			}) ;
			$('[data-action="reload_Sys.storage_data"]').click(function(){
				Sys.outputStorageData() ;
			}) ;
			$('[data-action="NewDocument"]').click(function(){
				document.title = Invariant["APP_NAME"] ;
				Sys.commonEditor.setValue("") ;
			}) ;
			$('[data-action="New_Tab"]').click(function(){
				window.open(location.href) ;
			}) ;
		} ,
	initDialog : function(){		//ダイアログボックスの初期化
		$("#Open").dialog({
			modal : true ,
			draggable : true ,
			title : "ファイルを開く" ,
			height : 240 ,
			width : 320 ,
			autoOpen : false ,
			buttons : {
				"OK" : function(event){
					var file = new util.File( document.getElementById("Open-file-chooser") , $("#Open-file-encode option:selected").val()) ;
					try{
						file.read(function(str){
							var mime = util.TransmissionMIMETypeForCodeMirror($("#Open-file-chooser")[0].value) ;
							Sys.commonEditor.setOption("mode" , mime) ;
							Sys.commonEditor.setValue(str) ;
							document.title = Invariant["APP_NAME"] + " -" + $("#Open-file-chooser")[0].value ;
							Sys.setWindowTitle(util.getFileFullPath($("#Open-file-chooser")[0]))
						}) ;
					}catch(e){
						alert("エラー : " + e) ;
					}
					$("#Open").dialog("close") ;
				} ,
				"キャンセル" : function(event){
					$("#Open").dialog("close") ;
				}
			}
		}) ;
		$("#searchbox").dialog({
			modal : false ,
			draggable : true ,
			title : "検索" ,
			height : 200 ,
			width : 300 ,
			autoOpen : false ,
			buttons : {
				"検索" : function(){
					CodeMirror.commands.find($("#search_query").val() , Sys.commonEditor) ;
				} ,
				"閉じる" : function(){
					$("#searchbox").dialog("close") ;
				}
			}
		}) ;
		$("#replacebox").dialog({
			modal : false ,
			draggable : true ,
			width : 530 ,
			height : 190 ,
			title : "置換" ,
			autoOpen : false ,
			buttons : {
				"検索" : function(){
					CodeMirror.commands.find($("#search_query_for_replace").val() , Sys.commonEditor) ;
				} ,
				"すべて置換" : function(){
					CodeMirror.commands.replace(Sys.commonEditor , true) ;
				}
			}
		}) ;
		$("#SettingEnvironment").dialog({
			modal : true ,
			draggable : true ,
			title : "環境設定" ,
			height : 400 ,
			width : 500 ,
			autoOpen : false ,
			buttons : {
				"OK" : function(){
					//テーマの設定
					Sys.storage.set("TextEditor.ThemeSelector" , $("#theme-selector option:selected").val()) ;
					//キーマップの設定
					Sys.storage.set("TextEditor.keyMap" , $("#keyMap option:selected").val()) ;
					//行番号の表示の有無
					Sys.storage.set("TextEditor.LineNumberShow" , $("#lineNumbers").is(":checked")) ;
					//背景画像の設定
					Sys.storage.set("TextEditor.BackGroundImageSource" , $("#background_image_src").val()) ;
					//背景画像透過率の設定
					Sys.storage.set("TextEditor.BackGroundImageOpacity" , $("#background_opacity").val()) ;
					//タブサイズの設定
					Sys.storage.set("TextEditor.TabSize" , $("#TabSize").val()) ;
					//起動時スクリプト
					Sys.storage.set("TextEditor.BeginScript" , $("#stating-js-code").val()) ;
					//初期化
					var value = Sys.commonEditor.getValue() ;
					var currentmode = Sys.commonEditor.getOption("mode") ;
					$(".CodeMirror").remove() ;
					Sys.init() ;
					Sys.commonEditor.setValue(value) ;
					Sys.commonEditor.setOption("mode" , currentmode) ;
					
					$("#SettingEnvironment").dialog("close") ;
				} ,
				"キャンセル" : function(){
					$("#SettingEnvironment").dialog("close") ;
				}
			}
		}) ;
		$("#About").dialog({
			modal : false ,
			draggable : true ,
			title : Invariant["APP_NAME"] + "について" ,
			height : 400 ,
			width : 320 ,
			buttons : {
				"OK" : function(e){
					$("#About").dialog("close") ;
				}
			} ,
			autoOpen : false
		}) ;
		$("#setenv-tabs").tabs() ;
	} ,
	init : function(){				//全体の初期化
		
		
		Sys.initSettingItem() ;
		Sys.outputStorageData() ;
		Sys.initCommonEditor() ;
		Sys.initClickedWork() ;
		Sys.initDialog() ;
		if(window.ActiveXObject){
			$(".CodeMirror-scroll").css("height" , (document.documentElement.clientHeight - 20) + "px")
			$("#background_image").css("height" , (document.documentElement.clientHeight - 20) + "px")
		}else{
			$(".CodeMirror-scroll").css("height" , (window.innerHeight - 20) + "px")
			$("#background_image").css("height" , (window.innerHeight - 20) + "px")
		}
		$(window).resize(function(){
			if(window.ActiveXObject){
				$(".CodeMirror-scroll").css("height" , (document.documentElement.clientHeight - 20) + "px")
				$("#background_image").css("height" , (document.documentElement.clientHeight - 20) + "px")
			}else{
				$(".CodeMirror-scroll").css("height" , (window.innerHeight - 20) + "px")
				$("#background_image").css("height" , (window.innerHeight - 20) + "px")
			}
		}) ;
		Sys.commonEditor.setValue("\n") ;	//行番号の幅がおかしいからこうしてやる。
		
		if(Sys.storage.get("TextEditor.BeginScript")){
			try{
				eval(Sys.storage.get("TextEditor.BeginScript")) ;
			}catch(e){
				alert(e) ;
			}
		}
	} ,
	setWindowTitle : function(filePath){	//ウィンドウタイトルの設定
		document.title = Invariant["APP_NAME"] + " -" + filePath ;
	} ,
	commonEditor : null ,			//メインエディタのCodeMirrorオブジェクト
	storage : null　,				//ストレージデータ
	beginEditor : null ,			//開始時実行のスクリプトのエディタ
	currentFile : null
}

window.xstorage = function(uu , storage){	//ストレージ利用可能後(window.onloadより後)
	Sys.storage = storage ;
	Sys.init(storage) ;	
}

$(function(){	
	document.title = Invariant["APP_NAME"] + " -無題" ;

	//jQueryで実装するメニューバー
	$("ul.sub").hide();
	$("ul.menubar li").hover(
		function(){
			$(">ul:not(:animated)",this).show() ;
		},
		function(){
			$(">ul",this).hide();
		}
	)



}) ;