/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.cat.wizards;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import benten.twa.cat.messages.BentenApplyExactMatchMessages;
import benten.twa.ui.wizards.AbstractWorkflowWellcomeWizardPage;

/**
 * 完全一致訳の適用
 *
 * <pre>
 * TMX の完全一致訳を XLIFF に適用します。
 *    1.  未翻訳の翻訳対象に対して訳の適用を試みます。
 *    2.  翻訳単位と完全一致する TMX を探し、翻訳単位に適用します。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳中間形式機械支援翻訳機能: 完全一致訳適用機能」に対応します。
 *
 * @author YAMAMOTO Koji
 */
public class ApplyExactMatchWizardPage extends AbstractWorkflowWellcomeWizardPage {
	/**
	 * 完全一致訳適用機能のためのメッセージ。
	 */
	protected static final BentenApplyExactMatchMessages fMsg = new BentenApplyExactMatchMessages();

	/**
	 * コンストラクター。
	 */
	protected ApplyExactMatchWizardPage() {
		setTitle(fMsg.getWizardPageTitle());
		setDescription(fMsg.getWizardPageDescription());
	}

	@Override
	public void createContent(final Composite composite) {
		final Label label = new Label(composite, SWT.WRAP);
		label.setText(fMsg.getWizardPageLabel1());
	}
}
