/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.cat.handler;

import java.io.IOException;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.SAXException;

import benten.twa.cat.core.BentenApplyExactMatchBatchProcess;
import benten.twa.cat.core.BentenApplyExactMatchProcessImpl;
import benten.twa.cat.core.valueobject.BentenApplyExactMatchProcessInput;
import benten.twa.cat.dialogs.ApplyExactMatchDialog;
import benten.twa.cat.messages.BentenApplyExactMatchMessages;
import benten.twa.cat.status.BentenApplyExactMatchStatus;
import benten.twa.ui.jobs.AbstractWorkflowHandler;

/**
 * 完全一致訳の適用
 *
 * <pre>
 * TMX の完全一致訳を XLIFF に適用します。
 *    1.  未翻訳の翻訳対象に対して訳の適用を試みます。
 *    2.  翻訳単位と完全一致する TMX を探し、翻訳単位に適用します。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳中間形式機械支援翻訳機能: 完全一致訳適用機能」に対応します。
 * 
 * @author IGA Tosiki
 */
public class ApplyExactMatchHandler extends AbstractWorkflowHandler {
	/**
	 * 完全一致訳適用機能のためのメッセージ。
	 */
	protected static final BentenApplyExactMatchMessages fMsg = new BentenApplyExactMatchMessages();

	@Override
	protected StatusDialog createDialog(final Shell shell, final IStructuredSelection selection) {
		setJobMessage(fMsg.getJobName());
		return new ApplyExactMatchDialog(shell, selection);
	}

	@Override
	protected void processFile(final IStatus iStatus) throws IOException, SAXException {
		final BentenApplyExactMatchStatus status = (BentenApplyExactMatchStatus) iStatus;

		final BentenApplyExactMatchProcessInput input = new BentenApplyExactMatchProcessInput();
		// input.setTmxdir は呼び出しません。
		input.setXliffdir(status.getXliffDir().getAbsolutePath());

		// ホワイトスペースを無視して TMX を検索するかどうかのフラグ。
		input.setIgnorewhitespacetmreference(status.getIgnoreWhitespaceTmReference());

		// ニーモニック・キーを無視して TMX を検索するかどうかのフラグ。
		input.setIgnoremnemonickeytmreference(status.getIgnoreMnemonicKeyTmReference());

		new BentenApplyExactMatchBatchProcess().validateInput(input);
		final BentenApplyExactMatchProcessImpl process = new BentenApplyExactMatchProcessImpl() {
			@Override
			protected void beginTask(final int totalWork) {
				monitor.beginTask(null, totalWork);
			}

			@Override
			public boolean progress(final String argProgressMessage) {
				monitor.subTask(argProgressMessage);
				monitor.worked(1);
				Thread.yield();
				return monitor.isCanceled();
			}

			@Override
			public boolean progressInner(final String argProgressMessage) {
				monitor.subTask(argProgressMessage);
				Thread.yield();
				return monitor.isCanceled();
			}
		};
		process.execute(input);
		resultInfo = process.getResultInfo();
	}
}
