/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.cat.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

import benten.twa.BentenTwaConstants;
import benten.twa.cat.messages.BentenApplyExistentTranslationMessages;
import benten.twa.cat.status.BentenApplyExistentTranslationStatus;
import benten.twa.ui.dialogs.AbstractWorkflowDialog;
import benten.ui.UiStatus;
import benten.ui.UiStatusException;
import benten.ui.fields.FolderTextField;
import benten.ui.fields.ResourceFolderTextField;
import benten.ui.preference.BentenPreference;
import benten.ui.preference.BentenPreference.Preference;

/**
 * 過去訳の適用
 *
 * <pre>
 * 過去訳を XLIFF に適用します。
 *  1.  翻訳単位の id をもとに過去訳を適用します。
 *  2.  翻訳後の XLIFF にある過去訳を、XLIFF に適用します。
 *  3.  この処理では TMX を利用しません。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳中間形式機械支援翻訳機能: 過去訳適用機能」に対応します。
 *
 * @author IGA Tosiki
 */
public class ApplyExistentTranslationDialog extends AbstractWorkflowDialog {

	/**
	 * 過去訳適用機能のためのメッセージ。
	 */
	protected static final BentenApplyExistentTranslationMessages fMsg = new BentenApplyExistentTranslationMessages();

	/** コントロール・コンテナー */
	private final ApplyExistentTranslationControls controls = new ApplyExistentTranslationControls();

	/** コントロール・コンテナー・クラス */
	public static class ApplyExistentTranslationControls {

		/** 入力ディレクトリー・テキスト */
		public FolderTextField fromDirText;

		/** 出力ディレクトリー・テキスト */
		public ResourceFolderTextField toDirText;

		/** 一時ディレクトリー・テキスト */
		public ResourceFolderTextField tmpDirText;
	}

	/**
	 * コンストラクター。
	 * @param parentShell 親シェル。
	 * @param selection 選択。
	 */
	public ApplyExistentTranslationDialog(final Shell parentShell, final IStructuredSelection selection) {
		super(parentShell, selection, fMsg.getWindowTitle());
	}

	@Override
	public void createControls(final Composite composite) {
		composite.setLayout(new GridLayout(3, false));

		controls.fromDirText = new FolderTextField(composite, fMsg.getDialogCtrlLabelFromDir());
		controls.fromDirText.addModifyListener(this);
		controls.fromDirText.setText(getSelectionResourceString());

		controls.toDirText = new ResourceFolderTextField(composite, fMsg.getDialogCtrlLabelToDir());
		controls.toDirText.addModifyListener(this);
		if (getSelectionResource() != null) {
			controls.toDirText.setText(getSelectionResource().getProject().getName()
					+ "/" + BentenTwaConstants.DEFAULT_XLIFF_DIR); //$NON-NLS-1$
		}

		controls.tmpDirText = new ResourceFolderTextField(composite, fMsg.getDialogCtrlLabelTmpDir());
		controls.tmpDirText.addModifyListener(this);
		if (getSelectionResource() != null) {
			controls.tmpDirText.setText(getSelectionResource().getProject().getName()
					+ "/" + BentenTwaConstants.DEFAULT_TMP_DIR); //$NON-NLS-1$
		}
	}

	@Override
	public IStatus getResultStatus() {
		final BentenApplyExistentTranslationStatus status = new BentenApplyExistentTranslationStatus();
		status.setFromDir(controls.fromDirText.getFile());
		status.setToDir(controls.toDirText.getFile());
		status.setTmpDir(controls.tmpDirText.getFile());
		status.setProject(controls.toDirText.getResource());

		// benten.cat.tm.ui.CatTmUiPlugin#fuzzyMatch のプリファランス処理内容と関連性があります。
		final IPreferenceStore store = BentenPreference.getStore();
		status.setIgnoreWhitespaceTmReference(store.getBoolean(Preference.IGNORE_WHITESPACE_TM_REFERENCE.name()));
		status.setIgnoreMnemonicKeyTmReference(store.getBoolean(Preference.IGNORE_MNEMONIC_KEY_TM_REFERENCE.name()));
		return status;
	}

	@Override
	public IStatus validate() throws UiStatusException {
		validatePath(controls.fromDirText);
		validatePath(controls.toDirText);
		validatePath(controls.tmpDirText);
		return UiStatus.OK_STATUS;
	}
}
