/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.core.io;

import java.io.File;
import java.io.FilenameFilter;

/**
 * 拡張子による HTML ファイル・フィルター。
 * 
 * @author KASHIHARA Shinji
 */
public class HtmlFileFilter implements FilenameFilter {

	/** このクラスのシングルトン・インスタンス */
	public static final FilenameFilter INSTANCE = new HtmlFileFilter();

	/** デフォルト拡張子 */
	public static final String DEFAULT_EXTENSION = ".html"; //$NON-NLS-1$

	/**
	 * 隠されたコンストラクター。
	 * 
	 * <UL>
	 * <LI>このクラスはユーティリティ・クラスです。
	 * <LI>インスタンス生成を抑制するために、コンストラクターは private で修飾されています。
	 * </UL>
	 */
	private HtmlFileFilter() {
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean accept(File dir, String name) {
		return name.endsWith(DEFAULT_EXTENSION) || name.endsWith(".htm"); //$NON-NLS-1$
	}

	/**
	 * ファイルに拡張子を追加。
	 * @param file ファイル
	 * @return 追加後のファイル
	 */
	public static File appendExtension(File file) {
		return new File(file + DEFAULT_EXTENSION);
	}
}
