/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.core.dom;

import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Element;

/**
 * XLIFF の alt-trans 要素デリゲート。
 *
 * @author KASHIHARA Shinji
 */
@SuppressWarnings("restriction")
public class AltTransDelegate extends TransBaseDelegate {

	/**
	 * コンストラクター。
	 * @param domDocument dom ドキュメント
	 * @param element 要素
	 */
	public AltTransDelegate(final IDOMDocument domDocument, final Element element) {
		super(domDocument, element);
	}

	/**
	 * origin 属性の取得。
	 * @return origin 属性
	 */
	public String getOrigin() {
		return getValue("@origin"); //$NON-NLS-1$
	}

	/**
	 * match-quality 属性の取得。
	 * @return match-quality 属性
	 */
	public String getMatchQuality() {
		return getValue("@match-quality"); //$NON-NLS-1$
	}
}
