/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.tm.core.messages;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * Benten TM ドライバー・マネージャのためのメッセージ。
 *
 * リソースバンドル定義: [BentenTmDriverManagerMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class BentenTmDriverManagerMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * BentenTmDriverManagerMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenTmDriverManagerMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public BentenTmDriverManagerMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/tm/core/messages/BentenTmDriverManagerMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenTmDriverManagerMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenTmDriverManagerMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public BentenTmDriverManagerMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/tm/core/messages/BentenTmDriverManagerMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenTmDriverManagerMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenTmDriverManagerMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public BentenTmDriverManagerMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/tm/core/messages/BentenTmDriverManagerMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BentenTmDriverManagerMessages], key[registerDriver_illegalArgument1]
     *
     * [BentenTmDriverManager#registerDriver: Invalid argument: driver must not be null.] (en)<br>
     * [BentenTmDriverManager#registerDriver: 不正な引数: driver は null であってはなりません。] (ja)<br>
     *
     * @return key[registerDriver_illegalArgument1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getRegisterDriverIllegalArgument1() {
        // 初期値として定義書の値を利用します。
        String strFormat = "BentenTmDriverManager#registerDriver: Invalid argument: driver must not be null.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("registerDriver_illegalArgument1");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenTmDriverManagerMessages], key[registerDriver_illegalArgument2]
     *
     * [BentenTmDriverManager#registerDriver: Invalid argument: driver#getName must not return null.] (en)<br>
     * [BentenTmDriverManager#registerDriver: 不正な引数: driver#getName は null を戻してはなりません。] (ja)<br>
     *
     * @return key[registerDriver_illegalArgument2]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getRegisterDriverIllegalArgument2() {
        // 初期値として定義書の値を利用します。
        String strFormat = "BentenTmDriverManager#registerDriver: Invalid argument: driver#getName must not return null.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("registerDriver_illegalArgument2");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenTmDriverManagerMessages], key[deregisterDriver_illegalArgument1]
     *
     * [BentenTmDriverManager#deregisterDriver: Invalid argument: driver must not be null.] (en)<br>
     * [BentenTmDriverManager#deregisterDriver: 不正な引数: driver は null であってはなりません。] (ja)<br>
     *
     * @return key[deregisterDriver_illegalArgument1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDeregisterDriverIllegalArgument1() {
        // 初期値として定義書の値を利用します。
        String strFormat = "BentenTmDriverManager#deregisterDriver: Invalid argument: driver must not be null.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("deregisterDriver_illegalArgument1");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenTmDriverManagerMessages], key[deregisterDriver_illegalArgument2]
     *
     * [BentenTmDriverManager#deregisterDriver: Invalid argument: driver#getName must not return null.] (en)<br>
     * [BentenTmDriverManager#deregisterDriver: 不正な引数: driver#getName は null を戻してはなりません。] (ja)<br>
     *
     * @return key[deregisterDriver_illegalArgument2]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDeregisterDriverIllegalArgument2() {
        // 初期値として定義書の値を利用します。
        String strFormat = "BentenTmDriverManager#deregisterDriver: Invalid argument: driver#getName must not return null.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("deregisterDriver_illegalArgument2");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenTmDriverManagerMessages], key[getDriver_illegalArgument1]
     *
     * [BentenTmDriverManager#getDriver: Invalid argument: driverName must not be null.] (en)<br>
     * [BentenTmDriverManager#getDriver: 不正な引数: driverName は null であってはなりません。] (ja)<br>
     *
     * @return key[getDriver_illegalArgument1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getGetDriverIllegalArgument1() {
        // 初期値として定義書の値を利用します。
        String strFormat = "BentenTmDriverManager#getDriver: Invalid argument: driverName must not be null.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("getDriver_illegalArgument1");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
