/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.filter.wizards;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import benten.twa.filter.messages.BentenConvertToXliffMessages;
import benten.twa.ui.wizards.AbstractWorkflowWellcomeWizardPage;

/**
 * 翻訳対象を XLIFF に変換。
 *
 * <pre>
 * 翻訳対象物を XLIFF に変換します。
 *   1.  プロジェクト内にインポートされた翻訳対象物を、XLIFF に変換します。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳対象物－翻訳中間形式変換機能: HTML－XLIFF変換機能」に対応します。
 *
 * @author YAMAMOTO Koji
 */
public class ConvertToXliffWizardPage extends AbstractWorkflowWellcomeWizardPage {

	/**
	 * HTML－XLIFF変換機能のためのメッセージ。
	 */
	protected static final BentenConvertToXliffMessages fMsg = new BentenConvertToXliffMessages();

	/**
	 * コンストラクター。
	 */
	protected ConvertToXliffWizardPage() {
		setTitle(fMsg.getWizardPageTitle());
		setDescription(fMsg.getWizardPageDescription());
	}

	@Override
	public void createContent(final Composite composite) {
		final Label label = new Label(composite, SWT.NULL);
		label.setText(fMsg.getWizardPageLabel1());
	}
}
