/*******************************************************************************
 * Copyright (c) 2007, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2010  NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.ui.compare;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.jface.text.WhitespaceCharacterPainter;
import org.eclipse.ui.texteditor.AbstractTextEditor;

/**
 * コンテンツ・マージ・ビューアー。
 *
 * <UL>
 * <LI>このクラスは {@link org.eclipse.compare.internal.ShowWhitespaceAction} 由来のものです。
 * <LI>パッケージ以外の変更はありません。
 * <LI>比較エディターで使用されます。
 * </UL>
 *
 * @author KASHIHARA Shinji
 */
@SuppressWarnings("restriction")
public class ShowWhitespaceAction extends TextEditorPropertyAction {

	@SuppressWarnings("unchecked")
	private Map fPainters;
	private boolean isWhitespaceShowing;
	private final boolean[] fNeedsPainters;

	public ShowWhitespaceAction(final MergeSourceViewer[] viewers, final boolean[] needsPainters) {
		super(CompareMessages.ShowWhitespaceAction_0, viewers, AbstractTextEditor.PREFERENCE_SHOW_WHITESPACE_CHARACTERS);
		fNeedsPainters = needsPainters;
		synchronizeWithPreference();
	}

	@Override
	protected boolean toggleState(final boolean checked) {
		if (fNeedsPainters == null)
			return false; // Not initialized yet
		if (checked) {
			showWhitespace();
		} else {
			hideWhitespace();
		}
		return true;
	}

	@SuppressWarnings("unchecked")
	private synchronized Map getPainters() {
		if (fPainters == null)
			fPainters = new HashMap();
		return fPainters;
	}

	@SuppressWarnings("unchecked")
	private void showWhitespace() {
		if (isWhitespaceShowing)
			return;
		try {
			final Map painters = getPainters();
			final MergeSourceViewer[] viewers = getViewers();
			for (int i = 0; i < viewers.length; i++) {
				if (fNeedsPainters[i]) {
					final MergeSourceViewer viewer = viewers[i];
					final WhitespaceCharacterPainter painter = new WhitespaceCharacterPainter(viewer.getSourceViewer());
					viewer.getSourceViewer().addPainter(painter);
					painters.put(viewer, painter);
				}
			}
		} finally {
			isWhitespaceShowing = true;
		}
	}

	@SuppressWarnings("unchecked")
	private void hideWhitespace() {
		final Map painters = getPainters();
		for (final Iterator iterator = painters.keySet().iterator(); iterator.hasNext();) {
			final MergeSourceViewer viewer = (MergeSourceViewer) iterator.next();
			final WhitespaceCharacterPainter painter = (WhitespaceCharacterPainter) painters.get(viewer);
			if (painter != null) {
				viewer.getSourceViewer().removePainter(painter);
				painter.deactivate(true);
			}
		}
		painters.clear();
		isWhitespaceShowing = false;
	}

}
