/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.validation;

import java.io.InputStream;

import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;

import org.osgi.framework.BundleContext;

import benten.core.AbstractBentenPlugin;

/**
 * CAT 検証プラグイン。
 * 
 * <UL>
 * <LI>このプラグインを Eclipse 上で有効化するためのプラグイン・クラスです。
 * </UL>
 * 
 * @author KASHIHARA Shinji
 */
public class CatValidationPlugin extends AbstractBentenPlugin {

	/** 共用インスタンス */
	private static CatValidationPlugin plugin;

	/** 翻訳禁止プロパティー */
	public static final PropertySet vForbiddenTransProp = new PropertySet();

	/** 用語検証プロパティー */
	public static final PropertySet vTermProp = new PropertySet();

	/** 対訳正規表現セット */
	public static final PropertySet vTransProp = new PropertySet();

	/** 対訳正規表現セット (逆引き) */
	public static final PropertySet vTransReverseProp = new PropertySet();

	@Override
	public void start(final BundleContext context) throws Exception {
		super.start(context);
		plugin = this;

		// jar プラグインに対応するために、ファイルはクラスローダー経由で取得
		vForbiddenTransProp.load(getInputStream("validation-forbidden-translation.properties")); //$NON-NLS-1$
		vTermProp.load(getInputStream("validation-term.properties")); //$NON-NLS-1$
		vTransProp.load(getInputStream("validation-translation.properties")); //$NON-NLS-1$
		vTransReverseProp.load(getInputStream("validation-translation-reverse.properties")); //$NON-NLS-1$
	}

	/**
	 * 入力ストリームの取得。
	 * @param fileName 入力ファイル名。conf/props/ 以下のファイルが対象です。
	 * @return ファイルから得られた入力ストリーム。
	 */
	private InputStream getInputStream(final String fileName) {
		return getClass().getClassLoader().getResourceAsStream("conf/props/" + fileName); //$NON-NLS-1$
	}

	@Override
	public void stop(final BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * このプラグインの共用インスタンスを取得。
	 * @return このプラグインの共用インスタンス
	 */
	public static CatValidationPlugin getDefault() {
		return plugin;
	}
}
