/*******************************************************************************
 benten.cat.glossary.engine.omegat - Benten default glossary engine.
 Copyright (C) 2009 Information-technology Promotion Agency, Japan.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, see <http://www.gnu.org/licenses>.
 *******************************************************************************/
package benten.cat.glossary.engine.omegat.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.framework.BundleContext;

import benten.cat.glossary.core.BentenGlossaryDriver;
import benten.cat.glossary.core.BentenGlossaryDriverManager;
import benten.cat.glossary.core.BentenGlossaryEngine;
import benten.cat.glossary.data.AbstractBentenGlossaryDataTsvPlugin;
import benten.cat.glossary.engine.AbstractBentenGlossaryEnginePlugin;
import benten.cat.glossary.engine.omegat.DefaultGlossaryDriver;
import benten.cat.tm.engine.omegat.ui.messages.OmegatGlossaryPluginMessages;
import benten.ui.preference.BentenPreference;
import benten.ui.preference.BentenPreference.Preference;

/**
 * Benten システムのデフォルトの用語集エンジン・プラグインである OmegaT 用語集プラグイン。
 * 
 * <UL>
 * <LI>このプラグインを Eclipse 上で有効化するためのプラグイン・クラスです。
 * </UL>
 * 
 * ★基本設計「共通機能: 用語対訳集エンジン機能」に対応します。
 * 
 * @author YAMAMOTO Koji
 */
public class OmegatGlossaryPlugin extends AbstractBentenGlossaryEnginePlugin {
	/** 共用インスタンス。 */
	private static OmegatGlossaryPlugin plugin;

	/**
	 * Benten デフォルト用語集エンジン・プラグインのためのメッセージ。
	 */
	protected static final OmegatGlossaryPluginMessages fMsg = new OmegatGlossaryPluginMessages();

	@Override
	public void start(final BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	@Override
	public void stop(final BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	@Override
	public AbstractBentenGlossaryEnginePlugin getPluginDefault() {
		return plugin;
	}

	@Override
	public BentenGlossaryDriver getDriver() {
		try {
			// 自らのドライバーを自己登録します。
			Class.forName("benten.cat.glossary.engine.omegat.DefaultGlossaryDriver"); //$NON-NLS-1$
		} catch (final ClassNotFoundException e) {
			log(fMsg.getGetDriverClassNotFoundException());
			log(e);
		}

		return BentenGlossaryDriverManager.getDriver(DefaultGlossaryDriver.DRIVER_NAME);
	}

	@Override
	public BentenGlossaryEngine getEngine() {
		if (fEngine == null) {
			fEngine = getDriver().getEngineInstance();
		}
		return fEngine;
	}

	@Override
	public void load() {
		getPluginDefault().log(fMsg.getLoadI001());

		getEngine().unload();

		for (File dir : getTsvDir()) {
			try {
				getEngine().loadTsv(dir);
			} catch (final IOException e) {
				getPluginDefault().log(e);
			}
		}
	}

	/**
	 * 拡張ポイントなどから TSV ディレクトリーを取得します。
	 * 
	 * @return TSV ディレクトリー。必ず null 以外が戻ります。
	 */
	private File[] getTsvDir() {
		final List<File> result = new ArrayList<File>();

		final IPreferenceStore store = BentenPreference.getStore();
		final boolean useTsvLocation = store.getBoolean(Preference.USE_TSV_LOCATION.name());
		if (useTsvLocation) {
			final String tsvFolder = store.getString(Preference.TSV_LOCATION.name());
			final File dir = new File(tsvFolder);
			result.add(dir);
			getPluginDefault().log(fMsg.getGetTsvDirI001(dir.getAbsolutePath()));
		} else {
			for (AbstractBentenGlossaryDataTsvPlugin plugin : getTsvDataPlugin()) {
				final File dir = plugin.getPluginDefault().getFile("/glossary"); //$NON-NLS-1$
				result.add(dir);
				getPluginDefault().log(fMsg.getGetTsvDirI001(dir.getAbsolutePath()));
			}
		}

		for (File dir : result) {
			if (dir.exists() == false) {
				throw new IllegalArgumentException(fMsg.getGetTsvDirE001(dir.getAbsolutePath()));
			}
			if (dir.isDirectory() == false) {
				throw new IllegalArgumentException(fMsg.getGetTsvDirE002(dir.getAbsolutePath()));
			}
		}

		return result.toArray(new File[result.size()]);
	}

	/**
	 * 拡張ポイントから用語集データ TSV プラグインを取得します。
	 * 
	 * @return 用語集データ TSV プラグインのリスト。必ず null 以外が戻ります。
	 */
	private List<AbstractBentenGlossaryDataTsvPlugin> getTsvDataPlugin() {
		final List<AbstractBentenGlossaryDataTsvPlugin> result = new ArrayList<AbstractBentenGlossaryDataTsvPlugin>();

		final IExtensionRegistry registry = Platform.getExtensionRegistry();
		final IExtensionPoint point = registry.getExtensionPoint("benten.cat.glossary.data.tsv"); //$NON-NLS-1$

		if (point == null) {
			throw new IllegalArgumentException(fMsg.getGetTsvDataPluginE001());
		}

		for (IExtension extension : point.getExtensions()) {
			for (IConfigurationElement cfgElem : extension.getConfigurationElements()) {
				try {
					final Object tsvPluginClass = cfgElem.createExecutableExtension("class"); //$NON-NLS-1$
					if (tsvPluginClass instanceof AbstractBentenGlossaryDataTsvPlugin) {
						result.add((AbstractBentenGlossaryDataTsvPlugin) tsvPluginClass);
					}
				} catch (final CoreException e) {
					getPluginDefault().log(e);
				}
			}
		}
		return result;
	}
}
