/*
 *  benten.cat.tm.engine.omegat - Benten default TM
 *                                (Translation Memory) engine.
 *  Copyright (C) 2009 Information-technology Promotion Agency, Japan.
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, see <http://www.gnu.org/licenses>.
 */
package benten.cat.tm.engine.omegat.messages;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * Benten デフォルト・エンジンのためのメッセージ。
 *
 * リソースバンドル定義: [DefaultTmEngineMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class DefaultTmEngineMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * DefaultTmEngineMessagesクラスのコンストラクタ。
     *
     * 基底名[DefaultTmEngineMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public DefaultTmEngineMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/tm/engine/omegat/messages/DefaultTmEngineMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * DefaultTmEngineMessagesクラスのコンストラクタ。
     *
     * 基底名[DefaultTmEngineMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public DefaultTmEngineMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/tm/engine/omegat/messages/DefaultTmEngineMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * DefaultTmEngineMessagesクラスのコンストラクタ。
     *
     * 基底名[DefaultTmEngineMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public DefaultTmEngineMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/tm/engine/omegat/messages/DefaultTmEngineMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[DefaultTmEngineMessages], key[Msg.0]
     *
     * [Failed to get the file listings of the specified directory: {0}] (en)<br>
     * [指定されたディレクトリーからファイル一覧取得に失敗しました。: {0}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[Msg.0]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg0(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Failed to get the file listings of the specified directory: {0}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.0");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[DefaultTmEngineMessages], key[Msg.1]
     *
     * [{0,number} units match found.] (en)<br>
     * [{0,number} 件のマッチがみつかりました。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.math.BigDecimal型を与えてください。
     * @return key[Msg.1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg1(final BigDecimal arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "{0,number} units match found.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.1");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[DefaultTmEngineMessages], key[Msg.2]
     *
     * [(Source Segment)] (en)<br>
     * [(原文)] (ja)<br>
     *
     * @return key[Msg.2]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg2() {
        // 初期値として定義書の値を利用します。
        String strFormat = "(Source Segment)";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.2");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[DefaultTmEngineMessages], key[Msg.3]
     *
     * [Unit No. {0,number}] (en)<br>
     * [{0,number} 件目] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.math.BigDecimal型を与えてください。
     * @return key[Msg.3]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg3(final BigDecimal arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Unit No. {0,number}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.3");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[DefaultTmEngineMessages], key[Msg.4]
     *
     * [{0,number} % match] (en)<br>
     * [{0,number} %マッチ] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.math.BigDecimal型を与えてください。
     * @return key[Msg.4]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg4(final BigDecimal arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "{0,number} % match";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.4");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[DefaultTmEngineMessages], key[Msg.5]
     *
     * [{0,number} units match found.] (en)<br>
     * [{0,number} 件のマッチがみつかりました。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.math.BigDecimal型を与えてください。
     * @return key[Msg.5]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg5(final BigDecimal arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "{0,number} units match found.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.5");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[DefaultTmEngineMessages], key[Msg.6]
     *
     * [(Source Segment)] (en)<br>
     * [(原文)] (ja)<br>
     *
     * @return key[Msg.6]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg6() {
        // 初期値として定義書の値を利用します。
        String strFormat = "(Source Segment)";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.6");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[DefaultTmEngineMessages], key[Msg.7]
     *
     * [Unit No. {0,number}] (en)<br>
     * [{0,number} 件目] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.math.BigDecimal型を与えてください。
     * @return key[Msg.7]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg7(final BigDecimal arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Unit No. {0,number}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.7");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[DefaultTmEngineMessages], key[Msg.8]
     *
     * [{0,number} % match] (en)<br>
     * [{0,number} %マッチ] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.math.BigDecimal型を与えてください。
     * @return key[Msg.8]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg8(final BigDecimal arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "{0,number} % match";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.8");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[DefaultTmEngineMessages], key[Msg.9]
     *
     * [Exception occurred while reading the TMX file [{0}]: {1}] (en)<br>
     * [TMX ファイル [{0}] の読み込み中に例外が発生しました。: {1}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.lang.String型を与えてください。
     * @return key[Msg.9]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg9(final String arg0, final String arg1) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Exception occurred while reading the TMX file [{0}]: {1}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.9");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }
}
