package jp.sf.beanbinder.petstore.dao.mock;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import jp.sf.beanbinder.petstore.dao.CategoryDao;
import jp.sf.beanbinder.petstore.dao.ItemDao;
import jp.sf.beanbinder.petstore.model.Category;
import jp.sf.beanbinder.petstore.model.Item;

public class ItemDaoImpl implements ItemDao {
    private List<Item> list = new ArrayList<Item>();
    
    public ItemDaoImpl() {
        try {
            CategoryDao dao = new CategoryDaoImpl();
            List<Category> categories = dao.findAll();
            
            //Fish
            Item item = new Item();
            item.setId(new Long(1)); item.setCategory(categories.get(0));
            item.setCode("FI-SW-01"); item.setName("Angelfish"); item.setUnitPrice(new BigDecimal(1700));
            item.setImage("./images/fish2.gif");
            this.list.add(item);
            
            item = new Item();
            item.setId(new Long(2)); item.setCategory(categories.get(0));
            item.setCode("FI-SW-02"); item.setName("Tiger Shark"); item.setUnitPrice(new BigDecimal(2000));
            item.setImage("./images/fish4.gif");
            this.list.add(item);
            
            item = new Item();
            item.setId(new Long(3)); item.setCategory(categories.get(0));
            item.setCode("FI-FW-01"); item.setName("Koi"); item.setUnitPrice(new BigDecimal(1700));
            item.setImage("./images/fish3.gif");
            this.list.add(item);
            
            item = new Item();
            item.setId(new Long(4)); item.setCategory(categories.get(0));
            item.setCode("FI-FW-02"); item.setName("Goldfish"); item.setUnitPrice(new BigDecimal(2000));
            item.setImage("./images/fish1.gif");
            this.list.add(item);
            
            //Dogs
            item = new Item();
            item.setId(new Long(5)); item.setCategory(categories.get(1));
            item.setCode("K9-BD-01"); item.setName("Bulldog"); item.setUnitPrice(new BigDecimal(180000));
            item.setImage("./images/dog1.gif");
            this.list.add(item);
            
            item = new Item();
            item.setId(new Long(6)); item.setCategory(categories.get(1));
            item.setCode("K9-PO-02"); item.setName("Poodle"); item.setUnitPrice(new BigDecimal(210000));
            item.setImage("./images/dog6.gif");
            this.list.add(item);
            
            item = new Item();
            item.setId(new Long(7)); item.setCategory(categories.get(1));
            item.setCode("K9-DL-01"); item.setName("Dalmation"); item.setUnitPrice(new BigDecimal(240000));
            item.setImage("./images/dog5.gif");
            this.list.add(item);
            
            item = new Item();
            item.setId(new Long(8)); item.setCategory(categories.get(1));
            item.setCode("K9-RT-01"); item.setName("Golden Retriever"); item.setUnitPrice(new BigDecimal(230000));
            item.setImage("./images/dog4.gif");
            this.list.add(item);
            
            item = new Item();
            item.setId(new Long(9)); item.setCategory(categories.get(1));
            item.setCode("K9-RT-02"); item.setName("Labrador Retriever"); item.setUnitPrice(new BigDecimal(220000));
            item.setImage("./images/dog4.gif");
            this.list.add(item);
            
            item = new Item();
            item.setId(new Long(10)); item.setCategory(categories.get(1));
            item.setCode("K9-CW-01"); item.setName("Chihuahua"); item.setUnitPrice(new BigDecimal(234000));
            item.setImage("./images/dog2.gif");
            this.list.add(item);
            
            //REPTILES
            item = new Item();
            item.setId(new Long(11)); item.setCategory(categories.get(2));
            item.setCode("RP-SN-01"); item.setName("Rattlesnake"); item.setUnitPrice(new BigDecimal(24000));
            item.setImage("./images/lizard3.gif");
            this.list.add(item);
            
            item = new Item();
            item.setId(new Long(12)); item.setCategory(categories.get(2));
            item.setCode("RP-LI-02"); item.setName("Iguana"); item.setUnitPrice(new BigDecimal(18000));
            item.setImage("./images/lizard2.gif");
            this.list.add(item);
            
            //CATS
            item = new Item();
            item.setId(new Long(13)); item.setCategory(categories.get(3));
            item.setCode("FL-DSH-01"); item.setName("Manx"); item.setUnitPrice(new BigDecimal(325000));
            item.setImage("./images/cat3.gif");
            this.list.add(item);
            
            item = new Item();
            item.setId(new Long(14)); item.setCategory(categories.get(3));
            item.setCode("FL-DLH-02"); item.setName("Persian"); item.setUnitPrice(new BigDecimal(280000));
            item.setImage("./images/cat1.gif");
            this.list.add(item);
            
            //BIRDS
            item = new Item();
            item.setId(new Long(15)); item.setCategory(categories.get(4));
            item.setCode("AV-CB-01"); item.setName("Amazon Parrot"); item.setUnitPrice(new BigDecimal(28500));
            item.setImage("./images/bird4.gif");
            this.list.add(item);
            
            item = new Item();
            item.setId(new Long(16)); item.setCategory(categories.get(4));
            item.setCode("AV-SB-02"); item.setName("Finch"); item.setUnitPrice(new BigDecimal(3000));
            item.setImage("./images/bird1.gif");
            this.list.add(item);
        }catch(Exception e) {
            e.printStackTrace();
        }
    }
    public List<Item> findAll() throws Exception {
        return list;
    }
    public List<Item> findByCategory(Category category) throws Exception {
        List<Item> list = new ArrayList<Item>();
        for(Item item : this.findAll()) {
            if( item.getCategory().getId().equals(category.getId()) ) {
                list.add(item);
            }
        }
        return list;
    }
}
