package jp.sf.beanbinder.petstore.dao.mock;

import java.util.ArrayList;
import java.util.List;

import jp.sf.beanbinder.petstore.dao.CategoryDao;
import jp.sf.beanbinder.petstore.model.Category;

public class CategoryDaoImpl implements CategoryDao {
    private List<Category> list = new ArrayList<Category>();
    
    public CategoryDaoImpl() {
        Category cat = new Category();
        cat.setId(new Long(1));
        cat.setName("Fish");
        cat.setImage("./images/fish1.gif");
        list.add(cat);
        
        cat = new Category();
        cat.setId(new Long(2));
        cat.setName("Dogs");
        cat.setImage("./images/dog1.gif");
        list.add(cat);
        
        cat = new Category();
        cat.setId(new Long(3));
        cat.setName("Reptiles");
        cat.setImage("./images/lizard1.gif");
        list.add(cat);
        
        cat = new Category();
        cat.setId(new Long(4));
        cat.setName("Cats");
        cat.setImage("./images/cat1.gif");
        list.add(cat);
        
        cat = new Category();
        cat.setId(new Long(5));
        cat.setName("Birds");
        cat.setImage("./images/bird1.gif");
        list.add(cat);
    }
    public List<Category> findAll() throws Exception {
        return list;
    }
    public Category findById(Long id) throws Exception {
        for(Category category : this.findAll()) {
            if( category.getId().equals(id) ) {
                return category;
            }
        }
        return null;
    }
}
