package jp.sf.beanbinder.petstore.controller;

import javax.swing.JOptionPane;

import jp.sf.beanbinder.BeanBinder;
import jp.sf.beanbinder.petstore.model.ItemDetail;
import jp.sf.beanbinder.petstore.model.Order;

public class Submit implements Command {

    public void execute(BeanBinder binder) {
        Order order = (Order)binder.getObject("order");
        String message = "";
     
        for(ItemDetail itemDetail : order.getItemDetails()) {
            message += String.format("品名:%-30s 単価:%-8d 数量:%-8d 合計:%-8d\n",
                    itemDetail.getItem().getName(), itemDetail.getItem().getUnitPrice().intValue(),
                    itemDetail.getQty().intValue(), itemDetail.getTotalPrice().intValue() );
        }
        message += String.format("小計:%-8d 消費税:%-8d 請求額:%-8d", order.getTotalPrice().intValue(), order.getTax().intValue(), order.getGross().intValue());
        
        JOptionPane.showMessageDialog(null, message, "SmallPetStoreはここまでです。", JOptionPane.INFORMATION_MESSAGE);
    }

}
