package jp.sf.beanbinder.petstore.controller;

import java.util.List;

import jp.sf.beanbinder.BeanBinder;
import jp.sf.beanbinder.adapter.Information;
import jp.sf.beanbinder.petstore.SmallPetStore;
import jp.sf.beanbinder.petstore.model.Category;
import jp.sf.beanbinder.petstore.model.Item;

public class PickCategory implements Command {

    public void execute(BeanBinder binder) {
        Category category = (Category)binder.getSelectedValue("jTable1");
        if( category == null )return;
        
        try {
            List<Item> itemList = SmallPetStore.itemDao.findByCategory(category);
            Information info = new Information();
            info.setImage(category.getImage());
            info.setTitle(category.getName());
            
            binder.setObject("itemList", itemList);
            binder.setObject("info", info);
        }catch(Exception e) {
            e.printStackTrace();
        }
        
        binder.updateComponent("pictureBox");
        binder.updateComponent("titleLabel");
        binder.updateComponent("jTable2");
    }

}
