/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.beanbinder.xml;

import java.io.File;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.sf.beanbinder.AlignType;
import jp.sf.beanbinder.BeanBinder;
import jp.sf.beanbinder.BindProperty;
import jp.sf.beanbinder.BindingBridge;
import jp.sf.beanbinder.CellRenderer;
import jp.sf.beanbinder.DefaultFormat;
import jp.sf.beanbinder.IMEMode;
import jp.sf.beanbinder.MappingParser;
import jp.sf.beanbinder.editor.CellEditor;
import jp.sf.beanbinder.listener.EditListener;
import jp.sf.beanbinder.validator.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XMLParser
implements MappingParser {
    private File xmlFile;
    private Object target;
    private BindingBridge bridge;
    private BeanBinder binder;
    List columns = new ArrayList();

    public XMLParser(BeanBinder binder, Object target, File xmlFile) {
        this.xmlFile = xmlFile;
        this.target = target;
        this.binder = binder;
    }

    public void parse() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(this.xmlFile);
            Element root = doc.getDocumentElement();
            if (!root.getNodeName().equals("bind")) {
                throw new Exception("\u30de\u30c3\u30d4\u30f3\u30b0\u60c5\u5831\u306f\u5fc5\u305a<bind>\u30bf\u30b0\u5185\u306b\u8a18\u8ff0\u3057\u307e\u3059\u3002:" + this.xmlFile.getAbsolutePath());
            }
            this.bridge = new BindingBridge(this.binder, this.target);
            this.parse(this.target, root);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    private void parse(Object target, Element root) throws Exception {
        NodeList basicList = root.getElementsByTagName("basic");
        NodeList selectList = root.getElementsByTagName("select");
        NodeList customList = root.getElementsByTagName("custom");
        NodeList tableList = root.getElementsByTagName("table");
        int i = 0;
        while (i < basicList.getLength()) {
            this.basicTag(this.target, (Element)basicList.item(i));
            ++i;
        }
        i = 0;
        while (i < selectList.getLength()) {
            this.selectTag(this.target, (Element)selectList.item(i));
            ++i;
        }
        i = 0;
        while (i < tableList.getLength()) {
            this.tableTag(this.target, (Element)tableList.item(i));
            ++i;
        }
    }

    private String getTagProp(Element tag, String name) {
        Node node = tag.getElementsByTagName(name).item(0);
        if (node == null) {
            return tag.getAttribute(name);
        }
        return node.getTextContent();
    }

    private int getTagPropInt(Element tag, String name) {
        String value = this.getTagProp(tag, name);
        return value == null || value.length() <= 0 ? 0 : Integer.parseInt(value);
    }

    private boolean getTagPropBoolean(Element tag, String name) {
        String value = this.getTagProp(tag, name);
        return value == null || value.length() <= 0 ? false : Boolean.parseBoolean(value);
    }

    private IMEMode getIMEMode(Element tag) throws Exception {
        String _imeMode = this.getTagProp(tag, "imeMode");
        IMEMode imeMode = (IMEMode)this.bridge.getConstValue(_imeMode);
        if (imeMode == null) {
            imeMode = IMEMode.DEFAULT;
        }
        return imeMode;
    }

    private Format getFormat(Element tag) throws Exception {
        String _format = this.getTagProp(tag, "formatField");
        Format format = (Format)this.bridge.getFieldValue(this.target, _format);
        if (format == null) {
            format = new DefaultFormat();
        }
        return format;
    }

    private AlignType getHorizon(Element tag) throws Exception {
        String _horizon = this.getTagProp(tag, "horizon");
        AlignType horizon = (AlignType)this.bridge.getConstValue(_horizon);
        if (horizon == null) {
            horizon = AlignType.LEFT;
        }
        return horizon;
    }

    private AlignType getVertical(Element tag) throws Exception {
        String _vertical = this.getTagProp(tag, "vertical");
        AlignType vertical = (AlignType)this.bridge.getConstValue(_vertical);
        if (vertical == null) {
            vertical = AlignType.TOP;
        }
        return vertical;
    }

    private Validator getValidator(Element tag) throws Exception {
        String _validator = this.getTagProp(tag, "validatorField");
        Validator validator = (Validator)this.bridge.getFieldValue(this.target, _validator);
        return validator;
    }

    private CellEditor getCellEditor(Element tag) throws Exception {
        String _cellEditor = this.getTagProp(tag, "cellEditorField");
        CellEditor cellEditor = (CellEditor)this.bridge.getFieldValue(this.target, _cellEditor);
        return cellEditor;
    }

    private CellRenderer getCellRenderer(Element tag) throws Exception {
        String _cellRenderer = this.getTagProp(tag, "cellRendererField");
        CellRenderer cellRenderer = (CellRenderer)this.bridge.getFieldValue(this.target, _cellRenderer);
        return cellRenderer;
    }

    private EditListener getEditListener(Element tag) throws Exception {
        String _editListener = this.getTagProp(tag, "editListenerField");
        EditListener editListener = (EditListener)this.bridge.getFieldValue(this.target, _editListener);
        return editListener;
    }

    private void basicTag(Object target, Element tag) throws Exception {
        String fieldName = this.getTagProp(tag, "field");
        if (fieldName == null) {
            throw new Exception("<field>\u8981\u7d20\u306e\u5b58\u5728\u3057\u306a\u3044\u30bf\u30b0\u304c\u767a\u898b\u3055\u308c\u307e\u3057\u305f\u3002:<basic>");
        }
        String objectKey = this.getTagProp(tag, "objectKey");
        String prop = this.getTagProp(tag, "prop");
        String group = this.getTagProp(tag, "group");
        this.bridge.bindBasic(fieldName, objectKey, prop, group, this.getIMEMode(tag), this.getFormat(tag), this.getHorizon(tag), this.getVertical(tag), this.getValidator(tag));
    }

    private void selectTag(Object target, Element tag) throws Exception {
        String fieldName = this.getTagProp(tag, "field");
        if (fieldName == null) {
            throw new Exception("<field>\u8981\u7d20\u306e\u5b58\u5728\u3057\u306a\u3044\u30bf\u30b0\u304c\u767a\u898b\u3055\u308c\u307e\u3057\u305f\u3002:<select>");
        }
        String destKey = this.getTagProp(tag, "destKey");
        String destValueProp = this.getTagProp(tag, "destValueProp");
        String destIdProp = this.getTagProp(tag, "destIdProp");
        String srcKey = this.getTagProp(tag, "srcKey");
        String srcDisplayProp = this.getTagProp(tag, "srcDisplayProp");
        String srcValueProp = this.getTagProp(tag, "srcValueProp");
        String srcIdProp = this.getTagProp(tag, "srcIdProp");
        String group = this.getTagProp(tag, "group");
        this.bridge.bindSelect(fieldName, group, destKey, destValueProp, destIdProp, srcKey, srcDisplayProp, srcValueProp, srcIdProp, this.getFormat(tag), this.getHorizon(tag), this.getVertical(tag), this.getValidator(tag));
    }

    private void customTag(Object target, Element tag) throws Exception {
        String fieldName = this.getTagProp(tag, "field");
        if (fieldName == null) {
            throw new Exception("<field>\u8981\u7d20\u306e\u5b58\u5728\u3057\u306a\u3044\u30bf\u30b0\u304c\u767a\u898b\u3055\u308c\u307e\u3057\u305f\u3002:<custom>");
        }
        String objectKey = this.getTagProp(tag, "objectKey");
        String displayProp = this.getTagProp(tag, "displayProp");
        String idProp = this.getTagProp(tag, "idProp");
        String group = this.getTagProp(tag, "group");
        this.bridge.bindCustom(fieldName, objectKey, displayProp, idProp, group, this.getIMEMode(tag), this.getFormat(tag), this.getHorizon(tag), this.getVertical(tag), this.getValidator(tag));
    }

    private void tableTag(Object target, Element tag) throws Exception {
        NodeList nodeList = tag.getElementsByTagName("column");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element columnTag = (Element)nodeList.item(i);
            String displayProp = this.getTagProp(columnTag, "displayProp");
            String valueProp = this.getTagProp(columnTag, "valueProp");
            String idProp = this.getTagProp(columnTag, "idProp");
            String text = this.getTagProp(columnTag, "text");
            boolean readOnly = this.getTagPropBoolean(columnTag, "readOnly");
            String prop = this.getTagProp(columnTag, "prop");
            int width = this.getTagPropInt(columnTag, "width");
            IMEMode imeMode = this.getIMEMode(columnTag);
            Format format = this.getFormat(columnTag);
            AlignType horizon = this.getHorizon(columnTag);
            AlignType vertical = this.getVertical(columnTag);
            Validator validator = this.getValidator(columnTag);
            CellEditor cellEditor = this.getCellEditor(columnTag);
            CellRenderer cellRenderer = this.getCellRenderer(columnTag);
            BindProperty col = this.bridge.bindColumn(displayProp, valueProp, idProp, text, readOnly, prop, width, imeMode, format, horizon, vertical, validator, cellEditor, cellRenderer);
            this.columns.add(col);
            ++i;
        }
        String fieldName = this.getTagProp(tag, "field");
        if (fieldName == null) {
            throw new Exception("<field>\u8981\u7d20\u306e\u5b58\u5728\u3057\u306a\u3044\u30bf\u30b0\u304c\u767a\u898b\u3055\u308c\u307e\u3057\u305f\u3002:<table>");
        }
        String objectKey = this.getTagProp(tag, "objectKey");
        String group = this.getTagProp(tag, "group");
        int rowHeight = this.getTagPropInt(tag, "height");
        boolean sortable = Boolean.parseBoolean(this.getTagProp(tag, "sortable"));
        EditListener editListener = this.getEditListener(tag);
        this.bridge.bindTable(fieldName, objectKey, group, rowHeight, sortable, editListener, this.columns.toArray(new BindProperty[0]));
    }
}

