/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.beanbinder.validator;

import java.math.BigDecimal;
import jp.sf.beanbinder.validator.ValidateDisplay;
import jp.sf.beanbinder.validator.ValidateResult;
import jp.sf.beanbinder.validator.Validator;

public class RangeValidator
extends Validator {
    private BigDecimal min;
    private BigDecimal max;

    public RangeValidator() {
    }

    public RangeValidator(Number min, Number max, String errorMessage, ValidateDisplay display) {
        super(errorMessage, display);
        this.min = new BigDecimal(min.doubleValue());
        this.max = new BigDecimal(max.doubleValue());
    }

    public ValidateResult checkValue(Object value, Object component) {
        try {
            BigDecimal number = new BigDecimal(value.toString());
            if (this.min != null ? number.doubleValue() < this.min.doubleValue() || number.doubleValue() > this.max.doubleValue() : number.doubleValue() > this.max.doubleValue()) {
                return ValidateResult.FAIL();
            }
            return ValidateResult.SUCCESS();
        }
        catch (Exception e) {
            return ValidateResult.FAIL();
        }
    }

    public BigDecimal getMax() {
        return this.max;
    }

    public void setMax(BigDecimal max) {
        this.max = max;
    }

    public BigDecimal getMin() {
        return this.min;
    }

    public void setMin(BigDecimal min) {
        this.min = min;
    }
}

